// DLPDaqApDlg.cpp : implementation file
#include "stdafx.h"
#include "DLPDaqAp.h"
#include "DLPDaqApDlg.h"
#include "FTD2XX.h"
#include "Search.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//bit manipulation macros
#define  SET(x, y)   ((x) |= (y)) 
#define  CLEAR(x, y)   ((x) &= (~y)) 

//global for digital I/O state
unsigned char LowByteHiLowState;

//data direction globals
#define OUTPUTMODE      0xFB 
#define INPUTMODE       0xF9
#define K1BITPOS        0x10
#define K2BITPOS        0x20 
#define K3BITPOS        0x40 
#define K4BITPOS        0x80 
unsigned char gP0dirbyte, gP1dirbyte;
unsigned char gP0statebyte, gP1statebyte;


//Chip Selects and clock enables
#define ADCS		0x08
#define DACS		0x10
#define PCS			0x20
#define DATASTATE	0x02 //the high/low state of data when configured as output
#define CLKSTATE	0x01
#define ACKLOOPZ    25
#define DACA		0x30
#define DACB		0x31
#define AD0			0xD0
#define AD1			0xF0


//Globals
int drivers_loaded;
int mpsse_ready;
CString ret_device_str;
char *BufPtrs[64]; // pointer to array of 64 pointers
DWORD numDevs;
int port_busy;
double volts[130];
double pw[4096], fqr[4096], fqi[4096];
 
float	maxpt = -80.0;
int		maxint=0;
#define MAX(a,b)        (((a)>(b)) ? (a):(b))
#define UP 1
#define DOWN 2



// CAboutDlg dialog used for App About
class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDLPDaqApDlg dialog

CDLPDaqApDlg::CDLPDaqApDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CDLPDaqApDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDLPDaqApDlg)
	m_SelOpen = _T("");
	m_MPSSEStatus = _T("");
	m_DisableMPSSE = _T("");
	m_DACVoltage = 0.0f;
	m_ADCResult = _T("");
	//m_Binno = 0;
	m_DACBVoltage = 0.0f;
	m_ADC1Result = _T("");
	m_DigiPortState = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CDLPDaqApDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDLPDaqApDlg)
	DDX_Text(pDX, IDC_EDIT_SEL_OPEN, m_SelOpen);
	DDX_Text(pDX, IDC_EDIT_MPSSE_STATUS, m_MPSSEStatus);
	DDX_Text(pDX, IDC_EDIT_DISABLE_MPSSE, m_DisableMPSSE);
	DDX_Text(pDX, IDC_EDIT_DAC_VOLTAGE, m_DACVoltage);
	DDX_Text(pDX, IDC_EDIT_ADC_RESULT, m_ADCResult);
	//DDX_Text(pDX, IDC_EDIT_BINNO, m_Binno);
	DDX_Text(pDX, IDC_EDIT_DACB_VOLTAGE, m_DACBVoltage);
	DDX_Text(pDX, IDC_EDIT_ADC1_RESULT, m_ADC1Result);
	DDX_Text(pDX, IDC_EDIT_DIGI_PORT_STATE, m_DigiPortState);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CDLPDaqApDlg, CDialog)
	//{{AFX_MSG_MAP(CDLPDaqApDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON_MPSSE_ON, OnButtonMpsseOn)
	ON_BN_CLICKED(IDC_BUTTON_SELECT_DEVICE, OnButtonSelectDevice)
	ON_BN_CLICKED(IDC_BUTTON_DISABLE_MPSSE, OnButtonDisableMpsse)
	ON_BN_CLICKED(IDC_BUTTON_CLOSEK0, OnButtonClosek0)
	ON_BN_CLICKED(IDC_BUTTON_OPENK0, OnButtonOpenk0)
	ON_BN_CLICKED(IDC_BUTTON_SET_DAC, OnButtonSetDac)
	ON_BN_CLICKED(IDC_BUTTON_SET_DAC_VOLTAGE, OnButtonSetDacVoltage)
	ON_BN_CLICKED(IDC_BUTTON_READ_ADC, OnButtonReadAdc)
	ON_BN_CLICKED(IDC_BUTTON_READ_ADC2, OnButtonReadAdc2)
	ON_BN_CLICKED(IDC_BUTTON_P04OUT, OnButtonP04out)
	ON_BN_CLICKED(IDC_BUTTON_CLOSEK1, OnButtonClosek1)
	ON_BN_CLICKED(IDC_BUTTON_CLOSEK2, OnButtonClosek2)
	ON_BN_CLICKED(IDC_BUTTON_CLOSEK3, OnButtonClosek3)
	ON_BN_CLICKED(IDC_BUTTON_MAKEP04INPUT, OnButtonMakep04input)
	ON_BN_CLICKED(IDC_BUTTON_P05OUT, OnButtonP05out)
	ON_BN_CLICKED(IDC_BUTTON_P06OUT, OnButtonP06out)
	ON_BN_CLICKED(IDC_BUTTON_P07OUT, OnButtonP07out)
	ON_BN_CLICKED(IDC_BUTTON_OPENK2, OnButtonOpenk2)
	ON_BN_CLICKED(IDC_BUTTON_OPENK3, OnButtonOpenk3)
	ON_BN_CLICKED(IDC_BUTTON_OPENK4, OnButtonOpenk4)
	ON_BN_CLICKED(IDC_BUTTON_MAKEP05INPUT, OnButtonMakep05input)
	ON_BN_CLICKED(IDC_BUTTON_MAKEP06INPUT, OnButtonMakep06input)
	ON_BN_CLICKED(IDC_BUTTON_MAKEP07INPUT, OnButtonMakep07input)
	ON_BN_CLICKED(IDC_BUTTON_SET_DAC2, OnButtonSetDac2)
	ON_BN_CLICKED(IDC_BUTTON_SET_DACB_VOLTAGE, OnButtonSetDacbVoltage)
	ON_BN_CLICKED(IDC_BUTTON_READ_ADC1, OnButtonReadAdc1)
	ON_WM_TIMER()
	ON_EN_CHANGE(IDC_EDIT_DACB_VOLTAGE, OnChangeEditDacbVoltage)
	ON_EN_CHANGE(IDC_EDIT_DAC_VOLTAGE, OnChangeEditDacVoltage)
	ON_BN_CLICKED(IDC_BUTTON_DEFAULT, OnButtonDefault)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()
// CDLPDaqApDlg message handlers




void CDLPDaqApDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CDLPDaqApDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CDLPDaqApDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}



//****************************************************************************************
BOOL CDLPDaqApDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	gP0dirbyte = 0xff;//init all digital I/Os to input (default)
	gP1dirbyte = 0xff;
	gP0statebyte = 0x00;//init all digital outputs to low
	gP1statebyte = 0x00;

	drivers_loaded = 1;
	if(LoadDLL() !=0)//returns 0 for success
	{
		AfxMessageBox("Error: DLL drivers not found.");				
		m_SelOpen = _T("Drivers not loaded");
		drivers_loaded = 0;
		return FALSE;
	}

	m_SelOpen = _T("DLL drivers loaded.");
	UpdateData(FALSE);
	UpdateWindow();

	port_busy=0;

	return TRUE;  // return TRUE  unless you set the focus to a control
}




//****************************************************************************************
int CDLPDaqApDlg::LoadDLL()//return 0 for success
{

	m_hmodule = LoadLibrary("Ftd2xx.dll");	
	if(m_hmodule == NULL)
	{
		return 1;
	}

	m_pWrite = (PtrToWrite)GetProcAddress(m_hmodule, "FT_Write");
	if (m_pWrite == NULL)
	{
		AfxMessageBox("Error: Can't Find FT_Write");
		return 1;
	}

	m_pRead = (PtrToRead)GetProcAddress(m_hmodule, "FT_Read");
	if (m_pRead == NULL)
	{
		AfxMessageBox("Error: Can't Find FT_Read");
		return 1;
	}

	m_pOpen = (PtrToOpen)GetProcAddress(m_hmodule, "FT_Open");
	if (m_pOpen == NULL)
	{
		AfxMessageBox("Error: Can't Find FT_Open");
		return 1;
	}

	m_pOpenEx = (PtrToOpenEx)GetProcAddress(m_hmodule, "FT_OpenEx");
	if (m_pOpenEx == NULL)
	{
		AfxMessageBox("Error: Can't Find FT_OpenEx");
		return 1;
	}

	m_pListDevices = (PtrToListDevices)GetProcAddress(m_hmodule, "FT_ListDevices");
	if(m_pListDevices == NULL)
	{
		AfxMessageBox("Error: Can't Find FT_ListDevices");
		return 1;
	}

	m_pClose = (PtrToClose)GetProcAddress(m_hmodule, "FT_Close");
	if (m_pClose == NULL)
	{
		AfxMessageBox("Error: Can't Find FT_Close");
		return 1;
	}

	m_pResetDevice = (PtrToResetDevice)GetProcAddress(m_hmodule, "FT_ResetDevice");
	if (m_pResetDevice == NULL)
	{
		AfxMessageBox("Error: Can't Find FT_ResetDevice");
		return 1;
	}

	m_pPurge = (PtrToPurge)GetProcAddress(m_hmodule, "FT_Purge");
	if (m_pPurge == NULL)
	{
		AfxMessageBox("Error: Can't Find FT_Purge");
		return 1;
	}

	m_pSetTimeouts = (PtrToSetTimeouts)GetProcAddress(m_hmodule, "FT_SetTimeouts");
	if (m_pSetTimeouts == NULL)
	{
		AfxMessageBox("Error: Can't Find FT_SetTimeouts");
		return 1;
	}

	m_pGetQueueStatus = (PtrToGetQueueStatus)GetProcAddress(m_hmodule, "FT_GetQueueStatus");
	if (m_pGetQueueStatus == NULL)
	{
		AfxMessageBox("Error: Can't Find FT_GetQueueStatus");
		return 1;
	}

	m_pSetBitMode = (PtrToSetBitMode)GetProcAddress(m_hmodule, "FT_SetBitMode");
	if (m_pSetBitMode == NULL)
	{
		AfxMessageBox("Error: Can't Find FT_SetBitMode");
		return 1;
	}


	m_pSetLatencyTimer = (PtrToSetLatencyTimer)GetProcAddress(m_hmodule, "FT_SetLatencyTimer");
	if (m_pSetLatencyTimer == NULL)
	{
		AfxMessageBox("Error: Can't Find FT_SetLatencyTimer.  ");
		return 1;
	}

	m_pGetLatencyTimer = (PtrToGetLatencyTimer)GetProcAddress(m_hmodule, "FT_GetLatencyTimer");
	if (m_pGetLatencyTimer == NULL)
	{
		AfxMessageBox("Error: Can't Find FT_GetLatencyTimer.  ");
		return 1;
	}

	m_pEE_Program = (PtrToEE_Program)GetProcAddress(m_hmodule, "FT_EE_Program");
	if (m_pEE_Program == NULL)
	{
		AfxMessageBox("Error: Can't Find FT_EE_Program");
		return 1;
	}

	m_pEE_Read = (PtrToEE_Read)GetProcAddress(m_hmodule, "FT_EE_Read");
	if (m_pEE_Read == NULL)
	{
		AfxMessageBox("Error: Can't Find FT_EE_Read");
		return 1;
	}
	
	return 0;
}	


//****************************************************************************************
FT_STATUS CDLPDaqApDlg::EE_Read(PFT_PROGRAM_DATA lpData)
{
	if (!m_pEE_Read)
	{
		AfxMessageBox("FT_EE_Read is not valid!"); 
		return FT_INVALID_HANDLE;
	}

	return (*m_pEE_Read)(m_ftHandle, lpData);
}	


//****************************************************************************************
FT_STATUS CDLPDaqApDlg::EE_Program(PFT_PROGRAM_DATA lpData)
{
	if (!m_pEE_Program)
	{
		AfxMessageBox("FT_EE_Program is not valid!"); 
		return FT_INVALID_HANDLE;
	}

	return (*m_pEE_Program)(m_ftHandle, lpData);
}	





//****************************************************************************************
FT_STATUS CDLPDaqApDlg::GetLatencyTimer(PUCHAR pucLatency)
{
	if (!m_pGetLatencyTimer)
	{
		AfxMessageBox("FT_GetLatencyTimer is not valid!"); 
		return FT_INVALID_HANDLE;
	}

	return (*m_pGetLatencyTimer)(m_ftHandle, pucLatency);
}	


//****************************************************************************************
FT_STATUS CDLPDaqApDlg::SetLatencyTimer(UCHAR ucLatency)
{
	if (!m_pSetLatencyTimer)
	{
		AfxMessageBox("FT_SetLatencyTimer is not valid!"); 
		return FT_INVALID_HANDLE;
	}

	return (*m_pSetLatencyTimer)(m_ftHandle, ucLatency);
}	


//****************************************************************************************
FT_STATUS CDLPDaqApDlg::SetBitMode(UCHAR ucMask, UCHAR ucEnable)
{
	if (!m_pSetBitMode)
	{
		AfxMessageBox("FT_SetBitMode is not valid!"); 
		return FT_INVALID_HANDLE;
	}

	return (*m_pSetBitMode)(m_ftHandle, ucMask, ucEnable);
}	

//****************************************************************************************
FT_STATUS CDLPDaqApDlg::Read(LPVOID lpvBuffer, DWORD dwBuffSize, LPDWORD lpdwBytesRead)
{
	if (!m_pRead)
	{
		AfxMessageBox("FT_Read is not valid!"); 
		return FT_INVALID_HANDLE;
	}

	return (*m_pRead)(m_ftHandle, lpvBuffer, dwBuffSize, lpdwBytesRead);
}	

//****************************************************************************************
FT_STATUS CDLPDaqApDlg::Write(LPVOID lpvBuffer, DWORD dwBuffSize, LPDWORD lpdwBytes)
{
	if (!m_pWrite)
	{
		AfxMessageBox("FT_Write is not valid!"); 
		return FT_INVALID_HANDLE;
	}
	
	return (*m_pWrite)(m_ftHandle, lpvBuffer, dwBuffSize, lpdwBytes);
}	

/*
//****************************************************************************************
FT_STATUS CDLPDaqApDlg::Open()
{
	if (!m_pOpen)
	{
		AfxMessageBox("FT_Open is not valid!"); 
		return FT_INVALID_HANDLE;
	}
	
	return (*m_pOpen)(NULL, &m_ftHandle);
}*/	


//****************************************************************************************
FT_STATUS CDLPDaqApDlg::Open(PVOID pvDevice)
{
	if (!m_pOpen)
	{
		AfxMessageBox("FT_Open is not valid!"); 
		return FT_INVALID_HANDLE;
	}
	
	return (*m_pOpen)(pvDevice, &m_ftHandle );
}	

//****************************************************************************************
FT_STATUS CDLPDaqApDlg::OpenEx(PVOID pArg1, DWORD dwFlags)
{
	if (!m_pOpenEx)
	{
		AfxMessageBox("FT_OpenEx is not valid!"); 
		return FT_INVALID_HANDLE;
	}
	
	return (*m_pOpenEx)(pArg1, dwFlags, &m_ftHandle);
}	


//****************************************************************************************
FT_STATUS CDLPDaqApDlg::ListDevices(PVOID pArg1, PVOID pArg2, DWORD dwFlags)
{
	if (!m_pListDevices)
	{
		AfxMessageBox("FT_ListDevices is not valid!"); 
		return FT_INVALID_HANDLE;
	}
	
	return (*m_pListDevices)(pArg1, pArg2, dwFlags);
}	


//****************************************************************************************
FT_STATUS CDLPDaqApDlg::Close()
{
	if (!m_pClose)
	{
		AfxMessageBox("FT_Close is not valid!"); 
		return FT_INVALID_HANDLE;
	}
	
	return (*m_pClose)(m_ftHandle);
}	

//****************************************************************************************
FT_STATUS CDLPDaqApDlg::ResetDevice()
{
	if (!m_pResetDevice)
	{
		AfxMessageBox("FT_ResetDevice is not valid!"); 
		return FT_INVALID_HANDLE;
	}
	
	return (*m_pResetDevice)(m_ftHandle);
}	

//****************************************************************************************
FT_STATUS CDLPDaqApDlg::Purge(DWORD dwMask)
{
	if (!m_pPurge)
	{
		AfxMessageBox("FT_Purge is not valid!"); 
		return FT_INVALID_HANDLE;
	}

	return (*m_pPurge)(m_ftHandle, dwMask);
}	

//****************************************************************************************
FT_STATUS CDLPDaqApDlg::SetTimeouts(DWORD dwReadTimeout, DWORD dwWriteTimeout)
{
	if (!m_pSetTimeouts)
	{
		AfxMessageBox("FT_SetTimeouts is not valid!"); 
		return FT_INVALID_HANDLE;
	}

	return (*m_pSetTimeouts)(m_ftHandle, dwReadTimeout, dwWriteTimeout);
}	

//****************************************************************************************
FT_STATUS CDLPDaqApDlg::GetQueueStatus(LPDWORD lpdwAmountInRxQueue)
{
	if (!m_pGetQueueStatus)
	{
		AfxMessageBox("FT_GetQueueStatus is not valid!"); 
		return FT_INVALID_HANDLE;
	}

	return (*m_pGetQueueStatus)(m_ftHandle, lpdwAmountInRxQueue);
}	






//************************************************************************
void CDLPDaqApDlg::OnButtonSelectDevice() 
{
	//search for Descriptions 
	FT_STATUS ftStatus;

	if(drivers_loaded==0)
	{
		AfxMessageBox("No drivers loaded!"); 
		return;
	}

	Close();//must be closed to perform the ListDevices() function

	UpdateData(TRUE);
	m_SelOpen = _T("Port CLOSED");
	m_MPSSEStatus = _T("");
	m_DisableMPSSE = _T("");
	UpdateData(FALSE);
	UpdateWindow();

	ftStatus = ListDevices(&numDevs, NULL, FT_LIST_NUMBER_ONLY);
	if(ftStatus != FT_OK) 
	{
		// FT_ListDevices failed
		AfxMessageBox("FT_ListDevices failed"); 
		return;
	}		
	else
	{
		if(numDevs<=0)
		{
			UpdateData(TRUE);
			m_SelOpen = _T("No devices attached");
			UpdateData(FALSE);
			UpdateWindow();		
			return;
		}

		ftStatus = ListDevices(&numDevs, NULL, FT_LIST_NUMBER_ONLY);
		if(ftStatus == FT_OK) 
		{
			for(DWORD d=0; d<numDevs; d++)
				BufPtrs[d] = new char[64];
			BufPtrs[d] = NULL;

			ftStatus = ListDevices(BufPtrs, &numDevs, FT_LIST_ALL|FT_OPEN_BY_DESCRIPTION);
			if (FT_SUCCESS(ftStatus)) 
			{
				CSearch dlg; //instantiate the device search class/dialog
				int nResponse = dlg.DoModal();		
				if (nResponse == IDOK)
				{
					// TODO: Place code here to handle when the dialog is dismissed with OK
					UpdateData(TRUE);
					m_SelOpen.Format("%s selected", ret_device_str);
					UpdateData(FALSE);
					UpdateWindow();	

					//open the selected device
					ftStatus = OpenEx((PVOID)(LPCTSTR)ret_device_str, FT_OPEN_BY_DESCRIPTION);
					if(ftStatus == FT_OK) 
					{
						UpdateData(TRUE);
						m_SelOpen.Format("%s opened", ret_device_str);
						UpdateData(FALSE);
						UpdateWindow();	
					}
					else
					{
						UpdateData(TRUE);
						m_SelOpen.Format("%s failed to open", ret_device_str);
						UpdateData(FALSE);
						UpdateWindow();	
					}
				}
				else if (nResponse == IDCANCEL)
				{
					// TODO: Place code here to handle when the dialog is dismissed with Cancel
					UpdateData(TRUE);
					m_SelOpen = _T("No device selected");
					UpdateData(FALSE);
					UpdateWindow();									
				}
			}
			else 
			{
				AfxMessageBox("ListDevices failed");
			}	

			//free ram to avoid memory leaks
			for(d=0; d<numDevs; d++)
				delete BufPtrs[d];  
		}
	}
}




//************************************************************************
void CDLPDaqApDlg::OnButtonMpsseOn() 
{
	unsigned char tx[100];
	//unsigned char rx[100];
	FT_STATUS status;
	DWORD ret_bytes;

	if(drivers_loaded==0)
	{
		AfxMessageBox("No drivers loaded!"); 
		return;
	}
	
	//set latency timer to 4mS
	SetLatencyTimer(4);
	SetTimeouts(40, 40);

	status = SetBitMode(0x0, 0x02);//enable MPSSE 
	if(status != FT_OK)
	{
		AfxMessageBox("Error enabling MPSSE!");

		UpdateData(TRUE);
		m_MPSSEStatus.Format("MPSSE enable failed");
		m_DisableMPSSE.Format(" ");
		UpdateData(FALSE);
		UpdateWindow();	
		
		mpsse_ready=0;
		return;
	}
	else
	{
		mpsse_ready=1;

		UpdateData(TRUE);
		m_DisableMPSSE.Format(" ");
		m_MPSSEStatus.Format("MPSSE enabled");
		UpdateData(FALSE);
		UpdateWindow();	
	}

//D7     D6      D5            D4       D3       D2        D1        D0  
//NC     NC      ParallelCS    DACS     ADCS     DataIN    DataOUT   CLK
//xx     xx      Out           Out      Out      In        Out       Out  -- 0xFB Output Mode
//xx     xx      Out           Out      Out      In        In        Out  -- 0xF9 Input Mode

	//initialize clock, data, and digital I/O on Low-Byte, 8-bit port 
	int pos=0;
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	LowByteHiLowState = 0xFB;//Initialize all high 1111 1011
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;//0xFB
	status = Write(tx, pos, &ret_bytes);
	if(status != FT_OK) 
	{
		AfxMessageBox("Error initializing Low-Byte I/O lines.");
		return;
	}

	//read data to purge buffer
	unsigned char rx[10];
	ret_bytes=1;
	while(ret_bytes>0)
		Read(rx, 50, &ret_bytes);

	unsigned char p0byte, p1byte;
	ReadIOBits(&p0byte, &p1byte, 0);
	gP0statebyte = p0byte;
	gP1statebyte = p1byte;

	ReadIOBits(&p0byte, &p1byte, 6);
	gP0dirbyte = p0byte;
	gP1dirbyte = p1byte;


	SetTimer(100, 333, NULL);
}



//************************************************************************
void CDLPDaqApDlg::OnButtonDisableMpsse() 
{
	while(port_busy);
	port_busy=1;

	FT_STATUS status;

	KillTimer(100);

	status = SetBitMode(0x0, 0x0);//disable MPSSE 
	if(status != FT_OK)
	{
		AfxMessageBox("Error disabling MPSSE!");

		UpdateData(TRUE);
		m_MPSSEStatus.Format("MPSSE disable failed");
		m_DisableMPSSE.Format("MPSSE disable failed");
		UpdateData(FALSE);
		UpdateWindow();	
	}
	else
	{
		UpdateData(TRUE);
		m_MPSSEStatus.Format("Disabled");
		m_DisableMPSSE.Format("MPSSE disabled");
		UpdateData(FALSE);
		UpdateWindow();	
	}

	//Close();//close USB port

	port_busy=0;
}




//D7     D6      D5            D4       D3       D2        D1        D0  
//NC     NC      ParallelCS    DACS     ADCS     DataIN    DataOUT   CLK
//xx     xx      Out           Out      Out      In        Out       Out  -- 0xFB Output Mode
//xx     xx      Out           Out      Out      In        In        Out  -- 0xF9 Input Mode





//************************************************************************
void CDLPDaqApDlg::SetClearIOBit(unsigned char p0statebyte, unsigned char p1statebyte)
{
	unsigned char tx[600];
	FT_STATUS status;
	DWORD ret_bytes;

	int pos=0;
	tx[pos++] = 0x86;//Set CLK divisor
	tx[pos++] = 0x42;//2.5uS 
	tx[pos++] = 0x00;
	
	//clock and data always start high

	//start condition
	
	//take parallel I/O clock enable low - this makes clock high at the parallel I/O chip
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	CLEAR(LowByteHiLowState, PCS);//take parallel I/O clock enable low
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;
	//repeat 3 times to correct the timing
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	CLEAR(LowByteHiLowState, PCS);//take parallel I/O clock enable low
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	CLEAR(LowByteHiLowState, PCS);//take parallel I/O clock enable low
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	CLEAR(LowByteHiLowState, PCS);//take parallel I/O clock enable low
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;

	//with clock high, take data low (repeat 4 times for the timing to be correct)
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	CLEAR(LowByteHiLowState, DATASTATE);//take data low
	tx[pos++] = LowByteHiLowState;// hi/low state if output (clock & data init to high)
	tx[pos++] = OUTPUTMODE;
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	CLEAR(LowByteHiLowState, DATASTATE);//take data low
	tx[pos++] = LowByteHiLowState;// hi/low state if output (clock & data init to high)
	tx[pos++] = OUTPUTMODE;
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	CLEAR(LowByteHiLowState, DATASTATE);//take data low
	tx[pos++] = LowByteHiLowState;// hi/low state if output (clock & data init to high)
	tx[pos++] = OUTPUTMODE;
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	CLEAR(LowByteHiLowState, DATASTATE);//take data low
	tx[pos++] = LowByteHiLowState;// hi/low state if output (clock & data init to high)
	tx[pos++] = OUTPUTMODE;

//send address byte
	//take clock low in preparation for writing to I2C
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	CLEAR(LowByteHiLowState, CLKSTATE);//take low
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;
	//clock out 1 byte, MSBit:01000000:LSBit, MSB first: Device code, address, and write command
	tx[pos++] = 0x11;//Clock out 1 byte, MSB first
	tx[pos++] = 0x00;//LengthL 0=1byte, 1=2bytes
	tx[pos++] = 0x00;//LengthH	
	tx[pos++] = 0x40;//Device code and address

	//data can only change while clock is low

	//set data direction to input for the ACK* from the MCP23016
	//set data direction to input 
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	CLEAR(LowByteHiLowState, DATASTATE);
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = INPUTMODE;
	//one additional clock to clock in the ACK
	tx[pos++] = 0x2E;//Clock out 1 bit, LSB first
	tx[pos++] = 0x00;//Length 0=1bit
	//clock held low until byte is processed
	for(int ackloops=0; ackloops<ACKLOOPZ; ackloops++)
	{
		tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
		CLEAR(LowByteHiLowState, CLKSTATE);//take low
		tx[pos++] = LowByteHiLowState;
		tx[pos++] = OUTPUTMODE;
	}

//clock out the data state command byte
	//set data direction of AD1 to output (make bit1 'DI' an output)
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;
	//clock out 1 byte
	tx[pos++] = 0x11;//Clock out 1 byte, MSB first
	tx[pos++] = 0x00;//LengthL 0=1byte, 1=2bytes
	tx[pos++] = 0x00;//LengthH	
	tx[pos++] = 0x00;//command 0: data state

	//set data direction to input for the ACK* from the MCP23016
	//set data direction to input 
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	CLEAR(LowByteHiLowState, DATASTATE);
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = INPUTMODE;
	//one additional clock to clock in the ACK
	tx[pos++] = 0x2E;//Clock out 1 bit, LSB first
	tx[pos++] = 0x00;//Length 0=1bit
	//clock held low until byte is processed
	for(ackloops=0; ackloops<ACKLOOPZ; ackloops++)
	{
		tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
		CLEAR(LowByteHiLowState, CLKSTATE);//take low
		tx[pos++] = LowByteHiLowState;
		tx[pos++] = OUTPUTMODE;
	}


	//clock out the first data state data byte
	//set data direction to output
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;
	//clock out 1 byte
	tx[pos++] = 0x11;//Clock out 1 byte, MSB first
	tx[pos++] = 0x00;//LengthL 0=1byte, 1=2bytes
	tx[pos++] = 0x00;//LengthH	
	tx[pos++] = p0statebyte;

	//set data direction to input for the ACK* from the MCP23016
	//set data direction to input 
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	CLEAR(LowByteHiLowState, DATASTATE);
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = INPUTMODE;
	//one additional clock to clock in the ACK
	tx[pos++] = 0x2E;//Clock out 1 bit, LSB first
	tx[pos++] = 0x00;//Length 0=1bit
	//clock held low until byte is processed
	for(ackloops=0; ackloops<ACKLOOPZ; ackloops++)
	{
		tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
		CLEAR(LowByteHiLowState, CLKSTATE);//take low
		tx[pos++] = LowByteHiLowState;
		tx[pos++] = OUTPUTMODE;
	}

	//clock out the second data state data byte
	//set data direction to output
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;
	//clock out 1 byte
	tx[pos++] = 0x11;//Clock out 1 byte, MSB first
	tx[pos++] = 0x00;//LengthL 0=1byte, 1=2bytes
	tx[pos++] = 0x00;//LengthH	
	tx[pos++] = p1statebyte;

	//set data direction to input for the ACK* from the MCP23016
	//set data direction to input 
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	CLEAR(LowByteHiLowState, DATASTATE);
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = INPUTMODE;
	//one additional clock to clock in the ACK
	tx[pos++] = 0x2E;//Clock out 1 bit, LSB first
	tx[pos++] = 0x00;//Length 0=1bit
	//clock held low until byte is processed
	for(ackloops=0; ackloops<ACKLOOPZ; ackloops++)
	{
		tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
		CLEAR(LowByteHiLowState, CLKSTATE);//take low
		tx[pos++] = LowByteHiLowState;
		tx[pos++] = OUTPUTMODE;
	}

	//take clock low 3-4 times to correct timiing
	//with clock high, take data low (repeat 4 times for the timing to be correct
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	CLEAR(LowByteHiLowState, CLKSTATE);//take clock low
	CLEAR(LowByteHiLowState, DATASTATE);//take data low
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;

//generate a stop condition
	//take clock high 3-4 times to correct timing
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	SET(LowByteHiLowState, CLKSTATE);//take clock high
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	SET(LowByteHiLowState, 0x01);//take clock high
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	SET(LowByteHiLowState, 0x01);//take clock high
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	SET(LowByteHiLowState, 0x01);//take clock high
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;
	
	//take data high
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	SET(LowByteHiLowState, DATASTATE);//take data high
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	SET(LowByteHiLowState, DATASTATE);//take data high
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	SET(LowByteHiLowState, DATASTATE);//take data high
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;

	//disabel Parallel I/O chip
	//take clock enable back high to disable
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	SET(LowByteHiLowState, PCS);//take enable high
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;

	while(port_busy);
	port_busy=1;

	//send the command string
	status = Write(tx, pos, &ret_bytes);
	port_busy=0;
	if(status != FT_OK) 
	{
		AfxMessageBox("Error writing to DAC. 1");
		return;
	}

}








//******************************************************************************************
void CDLPDaqApDlg::OnButtonReadAdc2() 
{
	unsigned char tx[3000], rx[500];
	FT_STATUS status;
	DWORD ret_bytes;

	KillTimer(100);

	//A/D Sample rate derived empirically:
	//0x01 = 57.1Ks/s unstable sample rate
	//0x02 = 53.8Ks/s unstable sample rate
	//0x03 = 46.7Ks/s unstable sample rate
	//0x08 = 28.57Ks/s slightly unstable
	//0x0A = 24.06Ks/s
	//0x0C = 20.6Ks/s
	//0x0D = 19.4Ks/s
	//0x10 = 16.2Ks/s 
	//0x20 = 8.7Ks/s
	//0x48 = 4.025Ks/s (approx) ******


	//Set CLK divisor so A/D will sample at approx. 4KHz
	int pos=0;
	tx[pos++] = 0x86;//rate command
	tx[pos++] = 0x48;//Clock Rate (sets the A/D sample rate) ******
	tx[pos++] = 0x00;
	

	for(int loops=0; loops<128; loops++)
	{
		//start condition
		//take ADC clock enable low - this makes clock high at the A/D
		tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
		CLEAR(LowByteHiLowState, ADCS);//take ADC clock enable low
		CLEAR(LowByteHiLowState, CLKSTATE);//take clock low
		tx[pos++] = LowByteHiLowState;//1110 0011  hi/low state if output (clock & data init to high)
		tx[pos++] = OUTPUTMODE;

		//send control nibble
		//clock out 4 bits, MSBit:10011011
		tx[pos++] = 0x13;//Clock out bits, MSB first
		tx[pos++] = 0x03;//3 = 4bits
		tx[pos++] = AD1;//1111  Start, Sngl/Diff, Odd/Sign, MSBF

		//set data direction of AD1 to input (make bit1 'DI' an input)
		tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
		tx[pos++] = LowByteHiLowState;// hi/low state if output (clock & data init to high)
		tx[pos++] = INPUTMODE;

		//read 2 bytes from A/D conversion
		tx[pos++] = 0x20;//Clock out 1 byte, MSB first
		tx[pos++] = 0x01;//LengthL 0=1byte, 1=2bytes
		tx[pos++] = 0x00;//LengthH	
		//this results in 2 bytes appearing in the RX buffer

		//take ADCS back high
		tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
		SET(LowByteHiLowState, ADCS);//take ADC enable high
		tx[pos++] = LowByteHiLowState;//1110 0011  hi/low state if output (clock & data init to high)
		tx[pos++] = OUTPUTMODE;
	}


	while(port_busy);
	port_busy=1;

	//send the command string
	status = Write(tx, pos, &ret_bytes);
	port_busy=0;
	if(status != FT_OK) 
	{
		//AfxMessageBox("Error writing to DAC. 2");
		port_busy=0;
		return;
	}

	SetTimeouts(40, 40);

	//read the reply
	status = Read(rx, 256, &ret_bytes);
	port_busy=0;

	if(status != FT_OK)
	{
		AfxMessageBox("Read Error!");
		return;		
	}

	if(ret_bytes < 256)
	{
		AfxMessageBox("error: too few bytes returned");
		return;		
	}

	int index;
	index=0;
	for(int x=0; x<256; x+=2)
	{
		unsigned char msb = rx[x]>>3;
		unsigned char lsb = ( (rx[x] & 0x07)<<5 | (rx[x+1]>>3) );
		int ivolts = ( msb<<8 | lsb );
		volts[index++] = (float)((float)ivolts /(float)0xFFF * 5.0);
	}

	SetTimer(100, 333, NULL);
	x=x;
}







//************************************************************************
void CDLPDaqApDlg::OnButtonOpenk0() 
{
	//clear the bit for P04 (K1) to make the output low
	CLEAR(gP0statebyte, K1BITPOS);

	SetClearIOBit( gP0statebyte, gP1statebyte);
}


//************************************************************************
void CDLPDaqApDlg::OnButtonOpenk2() 
{
	//clear the bit for P05 (K2) to make the output low
	CLEAR(gP0statebyte, K2BITPOS);

	SetClearIOBit( gP0statebyte, gP1statebyte);
}


//************************************************************************
void CDLPDaqApDlg::OnButtonOpenk3() 
{
	//clear the bit for P06 (K3) to make the output low
	CLEAR(gP0statebyte, K3BITPOS);

	SetClearIOBit( gP0statebyte, gP1statebyte);
}


//************************************************************************
void CDLPDaqApDlg::OnButtonOpenk4() 
{
	//clear the bit for P07 (K4) to make the output low
	CLEAR(gP0statebyte, K4BITPOS);

	SetClearIOBit( gP0statebyte, gP1statebyte);
}







//************************************************************************
void CDLPDaqApDlg::OnButtonClosek0()//K1
{
	//set the bit for P04 (K1) to make the output high (will only go high if pin is setup for output)
	SET(gP0statebyte, K1BITPOS);

	SetClearIOBit( gP0statebyte, gP1statebyte);
}

//**************************************************************************************************
void CDLPDaqApDlg::OnButtonClosek1()//K2
{
	//set the bit for P05 (K2) to make the output high (will only go high if pin is setup for output)
	SET(gP0statebyte, K2BITPOS);

	SetClearIOBit( gP0statebyte, gP1statebyte);
}

//**************************************************************************************************
void CDLPDaqApDlg::OnButtonClosek2()//K3
{
	//set the bit for P06 (K3) to make the output high (will only go high if pin is setup for output)
	SET(gP0statebyte, K3BITPOS);

	SetClearIOBit( gP0statebyte, gP1statebyte);
}

//**************************************************************************************************
void CDLPDaqApDlg::OnButtonClosek3()//K4
{
	//set the bit for P07 (K4) to make the output high (will only go high if pin is setup for output)
	SET(gP0statebyte, K4BITPOS);

	SetClearIOBit( gP0statebyte, gP1statebyte);
}





//************************************************************************
void CDLPDaqApDlg::OnButtonMakep04input() 
{
	//set the bit for P04 (K1) to select input
	SET(gP0dirbyte, K1BITPOS);

	SetDataDir( gP0dirbyte, gP1dirbyte);
}


//************************************************************************
void CDLPDaqApDlg::OnButtonMakep05input() 
{
	//set the bit for P05 (K2) to select input
	SET(gP0dirbyte, K2BITPOS);

	SetDataDir( gP0dirbyte, gP1dirbyte);
}

//************************************************************************
void CDLPDaqApDlg::OnButtonMakep06input() 
{
	//set the bit for P06 (K3) to select input
	SET(gP0dirbyte, K3BITPOS);

	SetDataDir( gP0dirbyte, gP1dirbyte);
}


//************************************************************************
void CDLPDaqApDlg::OnButtonMakep07input() 
{
	//set the bit for P07 (K4) to select input
	SET(gP0dirbyte, K4BITPOS);

	SetDataDir( gP0dirbyte, gP1dirbyte);
}






//************************************************************************
void CDLPDaqApDlg::OnButtonP04out() 
{
	//clear the bit for P04 (K1) to select output
	CLEAR(gP0dirbyte, K1BITPOS);

	SetDataDir( gP0dirbyte, gP1dirbyte);
}

//************************************************************************
void CDLPDaqApDlg::OnButtonP05out() 
{
	//clear the bit for P05 (K2) to select output
	CLEAR(gP0dirbyte, K2BITPOS);

	SetDataDir( gP0dirbyte, gP1dirbyte);
}

//************************************************************************
void CDLPDaqApDlg::OnButtonP06out() 
{
	//clear the bit for P06 (K3) to select output
	CLEAR(gP0dirbyte, K3BITPOS);
	
	SetDataDir( gP0dirbyte, gP1dirbyte);
}

//************************************************************************
void CDLPDaqApDlg::OnButtonP07out() 
{
	//clear the bit for P07 (K4) to select output
	CLEAR(gP0dirbyte, K4BITPOS);
	
	SetDataDir( gP0dirbyte, gP1dirbyte);
}



//************************************************************************
void CDLPDaqApDlg::SetDataDir(unsigned char p0dirbyte, unsigned char p1dirbyte)
{
	unsigned char tx[600];
	FT_STATUS status;
	DWORD ret_bytes;

	int pos=0;
	tx[pos++] = 0x86;//Set CLK divisor
	tx[pos++] = 0x42;//2.5uS 
	tx[pos++] = 0x00;
	
	//clock and data always start high

//start condition
	
	//take parallel I/O clock enable low - this makes clock high at the parallel I/O chip
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	CLEAR(LowByteHiLowState, PCS);//take parallel I/O clock enable low
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;
	//repeat 3 times to correct the timing
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	CLEAR(LowByteHiLowState, PCS);//take parallel I/O clock enable low
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	CLEAR(LowByteHiLowState, PCS);//take parallel I/O clock enable low
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	CLEAR(LowByteHiLowState, PCS);//take parallel I/O clock enable low
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;


	//with clock high, take data low (repeat 4 times for the timing to be correct)
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	CLEAR(LowByteHiLowState, DATASTATE);//take data low
	tx[pos++] = LowByteHiLowState;// hi/low state if output (clock & data init to high)
	tx[pos++] = OUTPUTMODE;

	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	CLEAR(LowByteHiLowState, DATASTATE);//take data low
	tx[pos++] = LowByteHiLowState;// hi/low state if output (clock & data init to high)
	tx[pos++] = OUTPUTMODE;
	
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	CLEAR(LowByteHiLowState, DATASTATE);//take data low
	tx[pos++] = LowByteHiLowState;// hi/low state if output (clock & data init to high)
	tx[pos++] = OUTPUTMODE;
	
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	CLEAR(LowByteHiLowState, DATASTATE);//take data low
	tx[pos++] = LowByteHiLowState;// hi/low state if output (clock & data init to high)
	tx[pos++] = OUTPUTMODE;

	//send address byte
	//take clock low in preparation for writing to I2C
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	CLEAR(LowByteHiLowState, CLKSTATE);//take low
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;
	//clock out 1 byte, MSBit:01000000:LSBit, MSB first: Device code, address, and write command
	tx[pos++] = 0x11;//Clock out 1 byte, MSB first
	tx[pos++] = 0x00;//LengthL 0=1byte, 1=2bytes
	tx[pos++] = 0x00;//LengthH	
	tx[pos++] = 0x40;//Device code and address

//#define OUTPUTMODE      0xFB 
//#define INPUTMODE       0xF9
//D7     D6      D5            D4       D3       D2        D1        D0  
//NC     NC      ParallelCS    DACS     ADCS     DataIN    DataOUT   CLK
//xx     xx      Out           Out      Out      In        Out       Out  -- 0xFB Output Mode
//xx     xx      Out           Out      Out      In        In        Out  -- 0xF9 Input Mode

//data can only change while clock is low

	//set data direction to input for the ACK* from the MCP23016
	//set data direction to input 
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	CLEAR(LowByteHiLowState, DATASTATE);
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = INPUTMODE;
	//one additional clock to clock in the ACK
	tx[pos++] = 0x2E;//Clock out 1 bit, LSB first
	tx[pos++] = 0x00;//Length 0=1bit
	//clock held low until byte is processed
	for(int ackloops=0; ackloops<ACKLOOPZ; ackloops++)
	{
		tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
		CLEAR(LowByteHiLowState, CLKSTATE);//take low
		tx[pos++] = LowByteHiLowState;
		tx[pos++] = OUTPUTMODE;
	}



	//clock out the first data direction command byte
	//set data direction of AD1 to output (make bit1 'DI' an output)
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;
	//clock out 1 byte
	tx[pos++] = 0x11;//Clock out 1 byte, MSB first
	tx[pos++] = 0x00;//LengthL 0=1byte, 1=2bytes
	tx[pos++] = 0x00;//LengthH	
	tx[pos++] = 0x06;//command 6: data direction

	//set data direction to input for the ACK* from the MCP23016
	//set data direction to input 
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	CLEAR(LowByteHiLowState, DATASTATE);
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = INPUTMODE;
	//one additional clock to clock in the ACK
	tx[pos++] = 0x2E;//Clock out 1 bit, LSB first
	tx[pos++] = 0x00;//Length 0=1bit
	//clock held low until byte is processed
	for(ackloops=0; ackloops<ACKLOOPZ; ackloops++)
	{
		tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
		CLEAR(LowByteHiLowState, CLKSTATE);//take low
		tx[pos++] = LowByteHiLowState;
		tx[pos++] = OUTPUTMODE;
	}

	//clock out the first data direction data byte
	//set data direction to output
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;
	//clock out 1 byte
	tx[pos++] = 0x11;//Clock out 1 byte, MSB first
	tx[pos++] = 0x00;//LengthL 0=1byte, 1=2bytes
	tx[pos++] = 0x00;//LengthH	
	tx[pos++] = p0dirbyte;

	//set data direction to input for the ACK* from the MCP23016
	//set data direction to input 
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	CLEAR(LowByteHiLowState, DATASTATE);
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = INPUTMODE;
	//one additional clock to clock in the ACK
	tx[pos++] = 0x2E;//Clock out 1 bit, LSB first
	tx[pos++] = 0x00;//Length 0=1bit
	//clock held low until byte is processed
	for(ackloops=0; ackloops<ACKLOOPZ; ackloops++)
	{
		tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
		CLEAR(LowByteHiLowState, CLKSTATE);//take low
		tx[pos++] = LowByteHiLowState;
		tx[pos++] = OUTPUTMODE;
	}

	//clock out the second data direction data byte
	//set data direction to output
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;
	//clock out 1 byte
	tx[pos++] = 0x11;//Clock out 1 byte, MSB first
	tx[pos++] = 0x00;//LengthL 0=1byte, 1=2bytes
	tx[pos++] = 0x00;//LengthH	
	tx[pos++] = p1dirbyte;

	//set data direction to input for the ACK* from the MCP23016
	//set data direction to input 
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	CLEAR(LowByteHiLowState, DATASTATE);
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = INPUTMODE;
	//one additional clock to clock in the ACK
	tx[pos++] = 0x2E;//Clock out 1 bit, LSB first
	tx[pos++] = 0x00;//Length 0=1bit
	//clock held low until byte is processed
	for(ackloops=0; ackloops<ACKLOOPZ; ackloops++)
	{
		tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
		CLEAR(LowByteHiLowState, CLKSTATE);//take low
		tx[pos++] = LowByteHiLowState;
		tx[pos++] = OUTPUTMODE;
	}

	//take clock low 3-4 times to correct timiing
	//with clock high, take data low (repeat 4 times for the timing to be correct
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	CLEAR(LowByteHiLowState, CLKSTATE);//take clock low
	CLEAR(LowByteHiLowState, DATASTATE);//take data low
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;

//generate a stop condition
	//take clock high 3-4 times to correct timing
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	SET(LowByteHiLowState, CLKSTATE);//take clock high
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	SET(LowByteHiLowState, 0x01);//take clock high
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	SET(LowByteHiLowState, 0x01);//take clock high
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	SET(LowByteHiLowState, 0x01);//take clock high
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;
	
	//take data high
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	SET(LowByteHiLowState, DATASTATE);//take data high
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	SET(LowByteHiLowState, DATASTATE);//take data high
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	SET(LowByteHiLowState, DATASTATE);//take data high
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;

	//disabel Parallel I/O chip
	//take clock enable back high to disable
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	SET(LowByteHiLowState, PCS);//take enable high
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;

	while(port_busy);
	port_busy=1;

	//send the command string
	status = Write(tx, pos, &ret_bytes);
	port_busy=0;
	if(status != FT_OK) 
	{
		AfxMessageBox("Error writing to DAC. 3");
		return;
	}
	


}




//************************************************************************
void CDLPDaqApDlg::OnButtonSetDac() 
{
	unsigned char tx[100];
	FT_STATUS status;
	DWORD ret_bytes;

	//take DACS low and clock 2 bytes of data into the DAC
	int pos=0;
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	CLEAR(LowByteHiLowState, DACS);//take DACS low
	CLEAR(LowByteHiLowState, CLKSTATE);//take CLock low
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;

	
	tx[pos++] = 0x11;//Clock out 2 bytes on positive edge, MSB first
	tx[pos++] = 0x02;//LengthL 0=1byte, 1=2bytes
	tx[pos++] = 0x00;//LengthH	
	tx[pos++] = DACA;
	tx[pos++] = 0x7F;//0111 1111
	tx[pos++] = 0xF0;//0111 1111

	//take DACS back high
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	SET(LowByteHiLowState, DACS);//take DACS high
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;

	while(port_busy);
	port_busy=1;

	status = Write(tx, pos, &ret_bytes);
	port_busy=0;
	if(status != FT_OK) 
	{
		AfxMessageBox("Error writing to DAC. 4");
		return;
	}
}	


//************************************************************************
void CDLPDaqApDlg::OnButtonSetDacVoltage() 
{
	unsigned char tx[100];
	FT_STATUS status;
	DWORD ret_bytes;
	int iVolts;

	UpdateData(TRUE);

	SetTimer(100, 333, NULL);

	if((m_DACVoltage > 5.0) || (m_DACVoltage < 0.0))
	{
		AfxMessageBox("Requested voltage out of range.  Please enter a value between 0 and 5 volts.");
		return;
	}

	iVolts = (int)(m_DACVoltage / 4.9999999 * 4095.0);

	unsigned char bhi, blo;

	//01111111 11110000
	bhi = (iVolts & 0x0ff0) >> 4;
	blo = (iVolts & 0x0f) << 4;

	//take DACS low and clock 2 bytes of data into the DAC
	int pos=0;
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	CLEAR(LowByteHiLowState, DACS);//take DACS low
	CLEAR(LowByteHiLowState, CLKSTATE);//take CLock low
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;
	
	tx[pos++] = 0x11;//Clock out 2 bytes on positive edge, MSB first
	tx[pos++] = 0x02;//LengthL 0=1byte, 1=2bytes
	tx[pos++] = 0x00;//LengthH	
	tx[pos++] = DACA;
	tx[pos++] = bhi;
	tx[pos++] = blo;

	//take DACS back high
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	SET(LowByteHiLowState, DACS);//take DACS high
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;

	while(port_busy);
	port_busy=1;

	status = Write(tx, pos, &ret_bytes);
	port_busy=0;
	if(status != FT_OK) 
	{
		AfxMessageBox("Error writing to DAC. 5");
		return;
	}
}




//************************************************************************
void CDLPDaqApDlg::OnButtonSetDac2() 
{
	unsigned char tx[100];
	FT_STATUS status;
	DWORD ret_bytes;

	//take DACS low and clock 2 bytes of data into the DAC
	int pos=0;
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	CLEAR(LowByteHiLowState, DACS);//take DACS low
	CLEAR(LowByteHiLowState, CLKSTATE);//take CLock low
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;

	
	tx[pos++] = 0x11;//Clock out 2 bytes on positive edge, MSB first
	tx[pos++] = 0x02;//LengthL 0=1byte, 1=2bytes
	tx[pos++] = 0x00;//LengthH	
	tx[pos++] = DACB;
	tx[pos++] = 0x7F;//0111 1111
	tx[pos++] = 0xF0;//0111 1111

	//take DACS back high
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	SET(LowByteHiLowState, DACS);//take DACS high
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;

	while(port_busy);
	port_busy=1;

	status = Write(tx, pos, &ret_bytes);
	port_busy=0;
	if(status != FT_OK) 
	{
		AfxMessageBox("Error writing to DAC. 6");
		return;
	}
}




//************************************************************************
void CDLPDaqApDlg::OnButtonSetDacbVoltage() 
{
	unsigned char tx[100];
	FT_STATUS status;
	DWORD ret_bytes;
	int iVolts;

	UpdateData(TRUE);

	SetTimer(100, 333, NULL);
	


	//set focus to the Set DACA button
	CButton *pbtn;	
	pbtn = (CButton *)GetDlgItem(IDC_BUTTON_SET_DAC_VOLTAGE);
	pbtn->SetFocus();


	if((m_DACVoltage > 5.0) || (m_DACVoltage < 0.0))
	{
		AfxMessageBox("Requested voltage out of range.  Please enter a value between 0 and 5 volts.");
		return;
	}

	iVolts = (int)(m_DACBVoltage / 4.9999999 * 4095.0);

	unsigned char bhi, blo;

	//01111111 11110000
	bhi = (iVolts & 0x0ff0) >> 4;
	blo = (iVolts & 0x0f) << 4;

	//take DACS low and clock 2 bytes of data into the DAC
	int pos=0;
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	CLEAR(LowByteHiLowState, DACS);//take DACS low
	CLEAR(LowByteHiLowState, CLKSTATE);//take CLock low
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;
	
	tx[pos++] = 0x11;//Clock out 2 bytes on positive edge, MSB first
	tx[pos++] = 0x02;//LengthL 0=1byte, 1=2bytes
	tx[pos++] = 0x00;//LengthH	
	tx[pos++] = DACB;
	tx[pos++] = bhi;
	tx[pos++] = blo;

	//take DACS back high
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	SET(LowByteHiLowState, DACS);//take DACS high
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;

	while(port_busy);
	port_busy=1;

	status = Write(tx, pos, &ret_bytes);
	port_busy=0;
	if(status != FT_OK) 
	{
		AfxMessageBox("Error writing to DAC. 7");
		return;
	}
}




//************************************************************************
void CDLPDaqApDlg::OnButtonReadAdc() 
{
	unsigned char tx[100], rx[100];
	FT_STATUS status;
	DWORD ret_bytes;

	UpdateData(TRUE);
	m_ADCResult.Format(" ");
	UpdateData(FALSE);
	UpdateWindow();

	int pos=0;
	tx[pos++] = 0x86;//Set CLK divisor
	tx[pos++] = 0x03; 
	tx[pos++] = 0x00;
	
	//start condition
	//take ADC clock enable low - this makes clock high at the A/D
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	CLEAR(LowByteHiLowState, ADCS);//take ADC clock enable low
	CLEAR(LowByteHiLowState, CLKSTATE);//take clock low
	tx[pos++] = LowByteHiLowState;//1110 0011  hi/low state if output (clock & data init to high)
	tx[pos++] = OUTPUTMODE;

	//send control nibble
	//clock out 4 bits, MSBit:10011011
	tx[pos++] = 0x13;//Clock out bits, MSB first
	tx[pos++] = 0x03;//3 = 4bits
	tx[pos++] = AD0;//1101  Start, Sngl/Diff, Odd/Sign, MSBF

	//set data direction of AD1 to input (make bit1 'DI' an input)
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	tx[pos++] = LowByteHiLowState;// hi/low state if output (clock & data init to high)
	tx[pos++] = INPUTMODE;

	//read 2 bytes from A/D conversion
	tx[pos++] = 0x20;//Clock out 1 byte, MSB first
	tx[pos++] = 0x01;//LengthL 0=1byte, 1=2bytes
	tx[pos++] = 0x00;//LengthH	
	//this results in 2 bytes appearing in the RX buffer

	//take ADCS back high
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	SET(LowByteHiLowState, ADCS);//take ADC enable high
	tx[pos++] = LowByteHiLowState;//1110 0011  hi/low state if output (clock & data init to high)
	tx[pos++] = 0xFB;//AD7:AD0  1111 1011   Data Direction  0=input  1=output

	while(port_busy);
	port_busy=1;

	//send the command string
	status = Write(tx, pos, &ret_bytes);
	port_busy=0;
	if(status != FT_OK) 
	{
		AfxMessageBox("Error writing to DAC. 8");
		return;
	}

	SetTimeouts(40, 40);

	//read the reply
	status = Read(rx, 2, &ret_bytes);
	if(status != FT_OK)
	{
		AfxMessageBox("Read Error!");
		return;		
	}

	if(ret_bytes < 2)
	{
		AfxMessageBox("error: too few bytes returned");
		return;		
	}

	UpdateData(TRUE);
	unsigned char msb = rx[0]>>3;
	unsigned char lsb = ( (rx[0] & 0x07)<<5 | (rx[1]>>3) );
	int ivolts = ( msb<<8 | lsb );
	float fvolts = (float)((float)ivolts /(float)0xFFF * 5.0);
	m_ADCResult.Format("%.2fV", fvolts);
	UpdateData(FALSE);
	UpdateWindow();
}



//********************************************************************************
void CDLPDaqApDlg::OnButtonReadAdc1() 
{
	unsigned char tx[100], rx[100];
	FT_STATUS status;
	DWORD ret_bytes;
	//int iVolts;


	UpdateData(TRUE);
	m_ADC1Result.Format(" ");
	UpdateData(FALSE);
	UpdateWindow();

	int pos=0;
	tx[pos++] = 0x86;//Set CLK divisor
	tx[pos++] = 0x03; 
	tx[pos++] = 0x00;
	
	//clock and data always start high

	//start condition
	//take ADC clock enable low - this makes clock high at the A/D
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	CLEAR(LowByteHiLowState, ADCS);//take ADC clock enable low
	CLEAR(LowByteHiLowState, CLKSTATE);//take clock low
	tx[pos++] = LowByteHiLowState;//1110 0011  hi/low state if output (clock & data init to high)
	tx[pos++] = OUTPUTMODE;

	//send control nibble
	//clock out 4 bits, MSBit:10011011
	tx[pos++] = 0x13;//Clock out bits, MSB first
	tx[pos++] = 0x03;//3 = 4bits
	tx[pos++] = AD1;//1111  Start, Sngl/Diff, Odd/Sign, MSBF

	//set data direction of AD1 to input (make bit1 'DI' an input)
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	tx[pos++] = LowByteHiLowState;// hi/low state if output (clock & data init to high)
	tx[pos++] = INPUTMODE;

	//read 2 bytes from A/D conversion
	tx[pos++] = 0x20;//Clock out 1 byte, MSB first
	tx[pos++] = 0x01;//LengthL 0=1byte, 1=2bytes
	tx[pos++] = 0x00;//LengthH	
	//this results in 2 bytes appearing in the RX buffer

	//take ADCS back high
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	SET(LowByteHiLowState, ADCS);//take ADC enable high
	tx[pos++] = LowByteHiLowState;//1110 0011  hi/low state if output (clock & data init to high)
	tx[pos++] = 0xFB;//AD7:AD0  1111 1011   Data Direction  0=input  1=output

	while(port_busy);
	port_busy=1;

	//send the command string
	status = Write(tx, pos, &ret_bytes);
	port_busy=0;
	if(status != FT_OK) 
	{
		AfxMessageBox("Error writing to DAC. 9");
		return;
	}

	SetTimeouts(40, 40);

	//read the reply
	status = Read(rx, 2, &ret_bytes);
	if(status != FT_OK)
	{
		AfxMessageBox("Read Error!");
		return;		
	}

	if(ret_bytes < 2)
	{
		AfxMessageBox("error: too few bytes returned");
		return;		
	}

	UpdateData(TRUE);
	unsigned char msb = rx[0]>>3;
	unsigned char lsb = ( (rx[0] & 0x07)<<5 | (rx[1]>>3) );
	int ivolts = ( msb<<8 | lsb );
	float fvolts = (float)((float)ivolts /(float)0xFFF * 5.0);
	m_ADC1Result.Format("%.2fV", fvolts);
	UpdateData(FALSE);
	UpdateWindow();
}



//************************************************************************
void CDLPDaqApDlg::ReadIOBits(unsigned char *p0statebyte, unsigned char *p1statebyte, int register_number)
{
	unsigned char tx[600], rx[10];
	FT_STATUS status;
	DWORD ret_bytes;


	//register_numbers:
	//0 - actual state of input/output of all 16 bits
	//2 - state of latch that drives the output buffers 
	//4 - polarity registers
	//6 - input/output direction registers
	//Use even values only.  Both even and odd numbered registers are returned with each call


	//read data to purge buffer
	ret_bytes=1;
	while(ret_bytes>0)
		Read(rx, 50, &ret_bytes);



	int pos=0;
	tx[pos++] = 0x86;//Set CLK divisor
	tx[pos++] = 0x42;//2.5uS 
	tx[pos++] = 0x00;
	
	//start condition
	
	//take parallel I/O clock enable low - this makes clock high at the parallel I/O chip
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	SET(LowByteHiLowState, CLKSTATE);//take bus clock hi
	CLEAR(LowByteHiLowState, PCS);//take parallel I/O clock enable low
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;
	//repeat 3 times to correct the timing
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	CLEAR(LowByteHiLowState, PCS);//take parallel I/O clock enable low
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	CLEAR(LowByteHiLowState, PCS);//take parallel I/O clock enable low
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	CLEAR(LowByteHiLowState, PCS);//take parallel I/O clock enable low
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;

	//with clock high, take data low (repeat 4 times for the timing to be correct)
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	CLEAR(LowByteHiLowState, DATASTATE);//take data low
	tx[pos++] = LowByteHiLowState;// hi/low state if output (clock & data init to high)
	tx[pos++] = OUTPUTMODE;
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	CLEAR(LowByteHiLowState, DATASTATE);//take data low
	tx[pos++] = LowByteHiLowState;// hi/low state if output (clock & data init to high)
	tx[pos++] = OUTPUTMODE;	
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	CLEAR(LowByteHiLowState, DATASTATE);//take data low
	tx[pos++] = LowByteHiLowState;// hi/low state if output (clock & data init to high)
	tx[pos++] = OUTPUTMODE;	
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	CLEAR(LowByteHiLowState, DATASTATE);//take data low
	tx[pos++] = LowByteHiLowState;// hi/low state if output (clock & data init to high)
	tx[pos++] = OUTPUTMODE;


//send address byte
	//take clock low in preparation for writing to I2C
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	CLEAR(LowByteHiLowState, CLKSTATE);//take low
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;
	//clock out 1 byte, MSBit:01000000:LSBit, MSB first: Device code, address, and write command
	tx[pos++] = 0x11;//Clock out 1 byte, MSB first
	tx[pos++] = 0x00;//LengthL 0=1byte, 1=2bytes
	tx[pos++] = 0x00;//LengthH	
	tx[pos++] = 0x40;//Device code, address and read bit

	//set data direction to input for the ACK* from the MCP23016
	//set data direction to input 
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	CLEAR(LowByteHiLowState, DATASTATE);
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = INPUTMODE;
	//one additional clock to clock in the ACK
//0
	tx[pos++] = 0x2E;//Clock out 1 bit, LSB first
	tx[pos++] = 0x00;//Length 0=1bit
	//clock held low until byte is processed
	for(int ackloops=0; ackloops<ACKLOOPZ; ackloops++)
	{
		tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
		CLEAR(LowByteHiLowState, CLKSTATE);//take low
		tx[pos++] = LowByteHiLowState;
		tx[pos++] = OUTPUTMODE;
	}

//clock out the register ID
	//set data direction of AD1 to output (make bit1 'DI' an output)
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;
	//clock out 1 byte
	tx[pos++] = 0x11;//Clock out 1 byte, MSB first
	tx[pos++] = 0x00;//LengthL 0=1byte, 1=2bytes
	tx[pos++] = 0x00;//LengthH	
	tx[pos++] = register_number;//starting register (1st of 2) to be read

	//set data direction to input for the ACK* from the MCP23016
	//set data direction to input 
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	CLEAR(LowByteHiLowState, DATASTATE);
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = INPUTMODE;
	//one additional clock to clock in the ACK
//1
	tx[pos++] = 0x2E;//Clock out 1 bit, LSB first
	tx[pos++] = 0x00;//Length 0=1bit
	//clock held low until byte is processed
	for(ackloops=0; ackloops<ACKLOOPZ; ackloops++)
	{
		tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
		CLEAR(LowByteHiLowState, CLKSTATE);//take low
		tx[pos++] = LowByteHiLowState;
		tx[pos++] = OUTPUTMODE;
	}

//REstart condition
	//take parallel I/O clock enable low - this makes clock high at the parallel I/O chip
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	CLEAR(LowByteHiLowState, PCS);//take parallel I/O clock enable low
	SET(LowByteHiLowState, CLKSTATE);//take bus clock hi
	SET(LowByteHiLowState, DATASTATE);//take bus clock hi
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;
	//repeat 3 times to correct the timing
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	CLEAR(LowByteHiLowState, PCS);//take parallel I/O clock enable low
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	CLEAR(LowByteHiLowState, PCS);//take parallel I/O clock enable low
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	CLEAR(LowByteHiLowState, PCS);//take parallel I/O clock enable low
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;

	//with clock high, take data low (repeat 4 times for the timing to be correct)
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	CLEAR(LowByteHiLowState, DATASTATE);//take data low
	tx[pos++] = LowByteHiLowState;// hi/low state if output (clock & data init to high)
	tx[pos++] = OUTPUTMODE;
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	CLEAR(LowByteHiLowState, DATASTATE);//take data low
	tx[pos++] = LowByteHiLowState;// hi/low state if output (clock & data init to high)
	tx[pos++] = OUTPUTMODE;	
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	CLEAR(LowByteHiLowState, DATASTATE);//take data low
	tx[pos++] = LowByteHiLowState;// hi/low state if output (clock & data init to high)
	tx[pos++] = OUTPUTMODE;	
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	CLEAR(LowByteHiLowState, DATASTATE);//take data low
	tx[pos++] = LowByteHiLowState;// hi/low state if output (clock & data init to high)
	tx[pos++] = OUTPUTMODE;


//send address byte and READ command
	//take clock low in preparation for writing to I2C
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	CLEAR(LowByteHiLowState, CLKSTATE);//take low
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;
	//clock out 1 byte, MSBit:01000000:LSBit, MSB first: Device code, address, and write command
	tx[pos++] = 0x11;//Clock out 1 byte, MSB first
	tx[pos++] = 0x00;//LengthL 0=1byte, 1=2bytes
	tx[pos++] = 0x00;//LengthH	
	tx[pos++] = 0x41;//Device code, address and read bit

	//set data direction to input for the ACK* from the MCP23016
	//set data direction to input 
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	CLEAR(LowByteHiLowState, DATASTATE);
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = INPUTMODE;
	//one additional clock to clock in the ACK
//2
	tx[pos++] = 0x2E;//Clock out 1 bit, LSB first
	tx[pos++] = 0x00;//Length 0=1bit
	//clock held low until byte is processed
	for(ackloops=0; ackloops<ACKLOOPZ+5; ackloops++)
	{
		tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
		CLEAR(LowByteHiLowState, CLKSTATE);//take low
		tx[pos++] = LowByteHiLowState;
		tx[pos++] = OUTPUTMODE;
	}


//clock in the first return data byte
	//set data direction to input
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = INPUTMODE;
	//clock in 1 byte
	tx[pos++] = 0x24;//Clock in 1 byte, MSB first
	tx[pos++] = 0x00;//LengthL 0=1byte, 1=2bytes
	tx[pos++] = 0x00;//LengthH	
//3 - valid data

	//already in the input mode...
	//one additional clock to clock in the ACK
//4
	tx[pos++] = 0x2E;//Clock out 1 bit, LSB first
	tx[pos++] = 0x00;//Length 0=1bit
	//clock held low until byte is processed
	for(ackloops=0; ackloops<ACKLOOPZ; ackloops++)
	{
		tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
		CLEAR(LowByteHiLowState, CLKSTATE);//take low
		tx[pos++] = LowByteHiLowState;
		tx[pos++] = OUTPUTMODE;
	}

	//clock in the second data byte
	//set data direction to input
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = INPUTMODE;
	//clock in 1 byte
	tx[pos++] = 0x24;//Clock in 1 byte, MSB first
	tx[pos++] = 0x00;//LengthL 0=1byte, 1=2bytes
	tx[pos++] = 0x00;//LengthH	
//5 - valid data
	//set data direction to input for the ACK* from the MCP23016
	//set data direction to input 
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	CLEAR(LowByteHiLowState, DATASTATE);
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = INPUTMODE;
	//one additional clock to clock in the ACK
	tx[pos++] = 0x2E;//Clock out 1 bit, LSB first
//6
	tx[pos++] = 0x00;//Length 0=1bit
	//clock held low until byte is processed
	for(ackloops=0; ackloops<ACKLOOPZ; ackloops++)
	{
		tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
		CLEAR(LowByteHiLowState, CLKSTATE);//take low
		tx[pos++] = LowByteHiLowState;
		tx[pos++] = OUTPUTMODE;
	}

	//take clock low 3-4 times to correct timiing
	//with clock high, take data low (repeat 4 times for the timing to be correct
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	CLEAR(LowByteHiLowState, CLKSTATE);//take clock low
	CLEAR(LowByteHiLowState, DATASTATE);//take data low
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;

//generate a stop condition
	//take clock high 3-4 times to correct timing
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	SET(LowByteHiLowState, CLKSTATE);//take clock high
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	SET(LowByteHiLowState, 0x01);//take clock high
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	SET(LowByteHiLowState, 0x01);//take clock high
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	SET(LowByteHiLowState, 0x01);//take clock high
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;
	
	//take data high
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	SET(LowByteHiLowState, DATASTATE);//take data high
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	SET(LowByteHiLowState, DATASTATE);//take data high
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	SET(LowByteHiLowState, DATASTATE);//take data high
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;

	//disabel Parallel I/O chip
	//take clock enable back high to disable
	tx[pos++] = 0x80;//Setup MPSSE Low byte I/O lines
	SET(LowByteHiLowState, PCS);//take enable high
	tx[pos++] = LowByteHiLowState;
	tx[pos++] = OUTPUTMODE;

	while(port_busy);
	port_busy=1;

	//send the command string
	status = Write(tx, pos, &ret_bytes);
	if(status != FT_OK) 
	{
		AfxMessageBox("Error writing to DAC. 1");
		return;
	}

	//read 2 bytes in and return data to the calling function
	status = Read(rx, 7, &ret_bytes);
	port_busy=0;
	if(status != FT_OK)
	{
		AfxMessageBox("Read Error!");
		return;		
	}

	if(ret_bytes < 2)
	{
		AfxMessageBox("error: too few bytes returned");
		return;		
	}

	*p0statebyte = rx[3];
	*p1statebyte = rx[5];

	return;
}




//***********************************************************************************************
void CDLPDaqApDlg::OnTimer(UINT nIDEvent) 
{
	unsigned char p0byte, p1byte;
	unsigned char p00, p01, p02, p03, p04, p05, p06, p07, p10, p11, p12, p13, p14, p15, p16, p17;

	p0byte=0;
	p1byte=0;

	ReadIOBits(&p0byte, &p1byte, 0);

	p00=p01=p02=p03=p04=p05=p06=p07=p10=p11=p12=p13=p14=p15=p16=p17=0;
	if(p0byte & 0x01) p00=1;
	if(p0byte & 0x02) p01=1;
	if(p0byte & 0x04) p02=1;
	if(p0byte & 0x08) p03=1;
	if(p0byte & 0x10) p04=1;
	if(p0byte & 0x20) p05=1;
	if(p0byte & 0x40) p06=1;
	if(p0byte & 0x80) p07=1;

	if(p1byte & 0x01) p10=1;
	if(p1byte & 0x02) p11=1;
	if(p1byte & 0x04) p12=1;
	if(p1byte & 0x08) p13=1;
	if(p1byte & 0x10) p14=1;
	if(p1byte & 0x20) p15=1;
	if(p1byte & 0x40) p16=1;
	if(p1byte & 0x80) p17=1;

	UpdateData(TRUE);
	m_DigiPortState.Format("Port 0:   %01.1d    %01.1d    %01.1d    %01.1d     %01.1d    %01.1d    %01.1d    %01.1d             Port 1:   %01.1d    %01.1d    %01.1d    %01.1d     %01.1d    %01.1d    %01.1d    %01.1d", 
													p07,p06,p05,p04,
													p03,p02,p01,p00,
													p17,p16,p15,p14,
													p13,p12,p11,p10	);
	UpdateData(FALSE);
	UpdateWindow();

	CDialog::OnTimer(nIDEvent);
}







//***********************************************************************************************
void CDLPDaqApDlg::OnChangeEditDacVoltage() 
{
	KillTimer(100);
}




//***********************************************************************************************
void CDLPDaqApDlg::OnChangeEditDacbVoltage() 
{
	KillTimer(100);
}





//************************************
void CDLPDaqApDlg::OnButtonDefault() 
{
}
