// TabRegisters.cpp : implementation file
//
/////////////////////////////////////////////////////
// This file is part of an RFID GUI. It is distributed as is
// and Texas Instruments does not provide any support.
// It is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
/////////////////////////////////////////////////////
// ShreHarsha Rao
/////////////////////////////////////////////////////

#include "stdafx.h"
#include "RFIDread.h"
#include "TabRegisters.h"

#pragma warning(disable: 4996)

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/*
static char SIDs[MAX_SID][SID_LEN];
unsigned char manufs[MAX_SID], blSizes[MAX_SID], numBls[MAX_SID];
unsigned short versions[MAX_SID];
static int selectedProtocol = -1,
		tTIbAddressed, tTIbInfo;
static CString tTISID, tTIBlockNum, tTIBlSize, tTIData;
 */

/////////////////////////////////////////////////////////////////////////////
// CTabRegisters dialog

// make it avalable to external functions:
static CTabRegisters *regDialog;


CTabRegisters::CTabRegisters(CWnd* pParent /*=NULL*/)
	: CDialog(CTabRegisters::IDD, pParent)
{
	//{{AFX_DATA_INIT(CTabRegisters)
	m_sRGCircStatus = _T("");
	m_sRGISOCtrl = _T("");
	m_sRGISOMode1 = _T("");
	m_sRGISOMode2 = _T("");
	m_sRGTXTimerH = _T("");
	m_sRGTXTimerL = _T("");
	m_sRGTXPulseLen = _T("");
	m_sRGRXNRWait = _T("");
	m_sRGRXWait = _T("");
	m_sRGModulator = _T("");
	m_sRGRXSpecial = _T("");
	m_sRGRegulator = _T("");
	m_sRGIRQ = _T("");
	m_sRGOscInt = _T("");
	m_sRGCollision = _T("");
	m_sRGRSSI = _T("");
	m_sRGTest1 = _T("");
	m_sRGTest2 = _T("");
	m_sRGFIFO = _T("");
	m_sRGTXLen1 = _T("");
	m_sRGTXLen2 = _T("");
	m_sRGFIFOwl = _T("");
	m_sRGnfcLowField = _T("");
	m_sRGnfcID = _T("");
	m_sRGnfcTargetLevel = _T("");
	m_sRGnfcTargetProt = _T("");
	//}}AFX_DATA_INIT
	regDialog = this;
}


void CTabRegisters::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTabRegisters)
	DDX_Text(pDX, IDC_RG_CIRC_STATUS, m_sRGCircStatus);
	DDV_MaxChars(pDX, m_sRGCircStatus, 2);
	DDX_Text(pDX, IDC_RG_ISO_CTRL, m_sRGISOCtrl);
	DDV_MaxChars(pDX, m_sRGISOCtrl, 2);
	DDX_Text(pDX, IDC_RG_ISO_MODE1, m_sRGISOMode1);
	DDV_MaxChars(pDX, m_sRGISOMode1, 2);
	DDX_Text(pDX, IDC_RG_ISO_MODE2, m_sRGISOMode2);
	DDV_MaxChars(pDX, m_sRGISOMode2, 2);
	DDX_Text(pDX, IDC_RG_TX_TIMER_H, m_sRGTXTimerH);
	DDV_MaxChars(pDX, m_sRGTXTimerH, 2);
	DDX_Text(pDX, IDC_RG_TX_TIMER_L, m_sRGTXTimerL);
	DDV_MaxChars(pDX, m_sRGTXTimerL, 2);
	DDX_Text(pDX, IDC_RG_TX_PULSE_LEN, m_sRGTXPulseLen);
	DDV_MaxChars(pDX, m_sRGTXPulseLen, 2);
	DDX_Text(pDX, IDC_RG_RX_NR_WAIT, m_sRGRXNRWait);
	DDV_MaxChars(pDX, m_sRGRXNRWait, 2);
	DDX_Text(pDX, IDC_RG_RX_WAIT, m_sRGRXWait);
	DDV_MaxChars(pDX, m_sRGRXWait, 2);
	DDX_Text(pDX, IDC_RG_MODULATOR, m_sRGModulator);
	DDV_MaxChars(pDX, m_sRGModulator, 2);
	DDX_Text(pDX, IDC_RG_RX_SPECIAL, m_sRGRXSpecial);
	DDV_MaxChars(pDX, m_sRGRXSpecial, 2);
	DDX_Text(pDX, IDC_RG_REGULATOR, m_sRGRegulator);
	DDV_MaxChars(pDX, m_sRGRegulator, 2);
	DDX_Text(pDX, IDC_RG_IRQ, m_sRGIRQ);
	DDV_MaxChars(pDX, m_sRGIRQ, 2);
	DDX_Text(pDX, IDC_RG_OSC_INT, m_sRGOscInt);
	DDV_MaxChars(pDX, m_sRGOscInt, 2);
	DDX_Text(pDX, IDC_RG_COLLISION, m_sRGCollision);
	DDV_MaxChars(pDX, m_sRGCollision, 2);
	DDX_Text(pDX, IDC_RG_RSSI, m_sRGRSSI);
	DDV_MaxChars(pDX, m_sRGRSSI, 5);
	DDX_Text(pDX, IDC_RG_TEST1, m_sRGTest1);
	DDV_MaxChars(pDX, m_sRGTest1, 2);
	DDX_Text(pDX, IDC_RG_TEST2, m_sRGTest2);
	DDV_MaxChars(pDX, m_sRGTest2, 2);
	DDX_Text(pDX, IDC_RG_FIFO, m_sRGFIFO);
	DDV_MaxChars(pDX, m_sRGFIFO, 2);
	DDX_Text(pDX, IDC_RG_TX_LEN1, m_sRGTXLen1);
	DDV_MaxChars(pDX, m_sRGTXLen1, 2);
	DDX_Text(pDX, IDC_RG_TX_LEN2, m_sRGTXLen2);
	DDV_MaxChars(pDX, m_sRGTXLen2, 2);
	DDX_Text(pDX, IDC_RG_FIFO_WL, m_sRGFIFOwl);
	DDV_MaxChars(pDX, m_sRGFIFOwl, 2);
	DDX_Text(pDX, IDC_RG_NFC_LOW_F, m_sRGnfcLowField);
	DDV_MaxChars(pDX, m_sRGnfcLowField, 2);
	DDX_Text(pDX, IDC_RG_NFC_ID, m_sRGnfcID);
	DDV_MaxChars(pDX, m_sRGnfcID, 24);
	DDX_Text(pDX, IDC_RG_NFC_T_LEVEL, m_sRGnfcTargetLevel);
	DDV_MaxChars(pDX, m_sRGnfcTargetLevel, 2);
	DDX_Text(pDX, IDC_RG_NFC_T_PROT, m_sRGnfcTargetProt);
	DDV_MaxChars(pDX, m_sRGnfcTargetProt, 2);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CTabRegisters, CDialog)
	//{{AFX_MSG_MAP(CTabRegisters)
	ON_BN_CLICKED(IDC_RG_READ, OnRGRead)
	ON_BN_CLICKED(IDC_RG_WRITE, OnRGWrite)
	ON_BN_CLICKED(IDC_RG_DEFAULTS, OnRGDefaults)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTabRegisters message handlers

/* 30-SEP-2010 */
BOOL CTabRegisters::OnInitDialog()
{
	GetDlgItem(IDC_RG_NFC_ID)->ShowWindow(SW_HIDE);
	GetDlgItem(IDC_RG_NFC_ID_T)->ShowWindow(SW_HIDE);
	return TRUE;
}
/* 30-SEP-2010 */


void CTabRegisters::NFCSetup()
{
        GetDlgItem(IDC_RG_NFC_T_PROT)->ShowWindow(SW_SHOWNA);
}


static int regsRead2(char regsX[24][26], int addr, int num) 
{
	char reply[CMD_LEN], cmd[8];
	int nn, x;
	sprintf(cmd, "13%2.2X%2.2X", num, addr);
	if (portWrite(cmd, 0, 0))
		return 1;
	nn = portRead(reply, CMD_LEN);
	if (nn <= 0)	return 1;

	char word[4], *p;
	int cnt = 0;
	for (p = reply; *p; ) {
		if (! (p = strchr(p, '[')))
			break;
		p++;
		if (*p && (*p == ']' || *p == 'z' || *p == 'Z'))
			continue;
		if (getXWord(&p, word))	continue;
		sscanf(word, "%x", &x);
		sprintf(regsX[cnt], "%2.2X", x);
		cnt++;
		if (cnt > num) {
			logAdd("Too many words", 0, 0);
			return 1;
			}
		}
	if (cnt != num) {
		char msg[256];
		sprintf(msg, "expecting %d words", num);
		logAdd(msg, 0, 0);
		return 1;
		}
	return 0;
}


static int regsRead(char regs[32][26], int *num) 
{
	char regsX[24][26], buf[32];
	int i;
	if (regsRead2(regsX, 0x00, 0x17))	return 1;
	for (i = 0; i < 0x17; i++)
		strcpy(regs[i], regsX[i]);
	// register 0x17 is 12 bytes long
	if (regsRead2(regsX, 0x17, 12))	return 1;
	strcpy(buf, regsX[11]);
	for (i = 10; i >= 0; i--)
		strcat(buf, regsX[i]);
	strcpy(regs[0x17], buf);
	if (regsRead2(regsX, 0x18, 8))	return 1;
	for (i = 0; i < 0x08; i++)
		strcpy(regs[i+0x18], regsX[i]);
	*num = 31;
	return 0;
}

char * hex2rssi (char *str)
{
	static char rssi[8];
	int stable, aux, active, val;
	sscanf(str, "%X", &val);
	stable = (val & 0x40) >> 6;
	aux = (val & 0x38) >> 3 ;
	active = val & 0x07;
	sprintf(rssi, "%d.%d.%d", stable, aux, active);
	return rssi;
}

static char * rssi2hex (char *str)
{
	static char hex[4];
	int stable, aux, active, val;
	if (sscanf(str, "%d.%d.%d", &stable, &aux, &active) == 3) {
		val = stable << 6 | aux << 3 | active;
		sprintf(hex, "%2.2X", val);
		}
	else
		strcpy(hex, "00");
	return hex;
}

void CTabRegisters::OnRGRead() 
{
	char regs[32][26];
	int cnt, i;
	if (regsRead(regs, &cnt))
	    return;
	for (i = 0; i < cnt; i++) {
		switch (i) {
		  case  0: m_sRGCircStatus = regs[i];	break;
		  case  1: m_sRGISOCtrl = regs[i];	break;
		  case  2: m_sRGISOMode1 = regs[i];	break;
		  case  3: m_sRGISOMode2 = regs[i];	break;
		  case  4: m_sRGTXTimerH = regs[i];	break;
		  case  5: m_sRGTXTimerL = regs[i];	break;
		  case  6: m_sRGTXPulseLen = regs[i];	break;
		  case  7: m_sRGRXNRWait = regs[i];	break;
		  case  8: m_sRGRXWait = regs[i];	break;
		  case  9: m_sRGModulator = regs[i];	break;
		  case 10: m_sRGRXSpecial = regs[i];	break;
		  case 11: m_sRGRegulator = regs[i];	break;
		  case 12: m_sRGIRQ = regs[i];	break;
		  case 13: m_sRGOscInt = regs[i];	break;
		  case 14: m_sRGCollision = regs[i];	break;
		  case 20: m_sRGFIFOwl = regs[i];	break;
		  case 22: m_sRGnfcLowField = regs[i];	break;
/* 30-SEP-2010 *
		  case 23: m_sRGnfcID = regs[i];	break;
 * 30-SEP-2010 */
		  case 24: m_sRGnfcTargetLevel = regs[i];	break;
		  case 25: m_sRGnfcTargetProt = regs[i];	break;
		  case 26: m_sRGTest1 = regs[i];	break;
		  case 27: m_sRGTest2 = regs[i];	break;
		  case 28: m_sRGFIFO = regs[i];	break;
		  case 29: m_sRGTXLen1 = regs[i];	break;
		  case 30: m_sRGTXLen2 = regs[i];	break;
		  }
		}
logAdd("top update", 0, 0);
	topUpdateFlagsGUI(regs[0]);
	UpdateData(FALSE);	// Set screen values
}

void registersRead() 
{
	regDialog->registersRead();
}

void CTabRegisters::registersRead() 
{
	regDialog->OnRGRead();
}

void CTabRegisters::OnRGWrite() 
{
	char regs[32][26];
	int noChange = 1, cnt, i;
	if (regsRead(regs, &cnt))
	    return;
	UpdateData(TRUE);	// Get curret values from the screen
	char screen[32][26];
	for (i = 0; i < cnt; i++) {
		switch (i) {
		  case  0: strcpy(screen[i], m_sRGCircStatus.GetBuffer(0)); break;
		  case  1: strcpy(screen[i], m_sRGISOCtrl.GetBuffer(0)); break;
		  case  2: strcpy(screen[i], m_sRGISOMode1.GetBuffer(0)); break;
		  case  3: strcpy(screen[i], m_sRGISOMode2.GetBuffer(0)); break;
		  case  4: strcpy(screen[i], m_sRGTXTimerH.GetBuffer(0)); break;
		  case  5: strcpy(screen[i], m_sRGTXTimerL.GetBuffer(0)); break;
		  case  6: strcpy(screen[i], m_sRGTXPulseLen.GetBuffer(0)); break;
		  case  7: strcpy(screen[i], m_sRGRXNRWait.GetBuffer(0)); break;
		  case  8: strcpy(screen[i], m_sRGRXWait.GetBuffer(0)); break;
		  case  9: strcpy(screen[i], m_sRGModulator.GetBuffer(0)); break;
		  case 10: strcpy(screen[i], m_sRGRXSpecial.GetBuffer(0)); break;
		  case 11: strcpy(screen[i], m_sRGRegulator.GetBuffer(0)); break;
		  case 12: strcpy(screen[i], m_sRGIRQ.GetBuffer(0)); break;
		  case 13: strcpy(screen[i], m_sRGOscInt.GetBuffer(0)); break;
		  case 14: strcpy(screen[i], m_sRGCollision.GetBuffer(0)); break;
		  case 15: strcpy(screen[i], rssi2hex(m_sRGRSSI.GetBuffer(0))); break;
		  case 20: strcpy(screen[i], m_sRGFIFOwl.GetBuffer(0)); break;
		  case 22: strcpy(screen[i], m_sRGnfcLowField.GetBuffer(0)); break;
/* 30-SEP-2010
		  case 23: strcpy(screen[i], m_sRGnfcID.GetBuffer(0)); break;
 * 30-SEP-2010 */
		  case 24: strcpy(screen[i], m_sRGnfcTargetLevel.GetBuffer(0)); break;
		  case 25: strcpy(screen[i], m_sRGnfcTargetProt.GetBuffer(0)); break;
		  case 26: strcpy(screen[i], m_sRGTest1.GetBuffer(0)); break;
		  case 27: strcpy(screen[i], m_sRGTest2.GetBuffer(0)); break;
		  case 28: strcpy(screen[i], m_sRGFIFO.GetBuffer(0)); break;
		  case 29: strcpy(screen[i], m_sRGTXLen1.GetBuffer(0)); break;
		  case 30: strcpy(screen[i], m_sRGTXLen2.GetBuffer(0)); break;
		  }
		}
	char cmd[64], all[64], one[8], reply[CMD_LEN];
	all[0] = 0;
	for (i = 0; i < cnt; i++) {
		// skip RO registers and long registers
		if (i == 12 || i == 13 || i ==14 || i == 15 || i == 28 ||
	/* RAM */	i == 0x10 || i == 0x11 || i == 0x12 || i == 0x13 ||
	/* RAM */	i == 0x15 ||
	/* long */	i == 0x17)
			continue;
		if (strcmp(regs[i], screen[i])) {
			sprintf(one, "%2.2X%s", i, screen[i]);
			strcat(all, one);
			}
		}
	// write long registers if required
/* 30-SEP-2010
    char buf[26];
	i = 0x17;
	if (strcmp(regs[i], screen[i])) {
		noChange = 0;
		sprintf(buf, "%s", screen[i]);
		sprintf(one, "%2.2X%s", i, screen[i]);
		one[2] = buf[4]; one[3] = buf[5];
		one[6] = buf[0]; one[7] = buf[1];
		sprintf(cmd, "11%s", one);
		if (portWrite(cmd, 0, 0))
			return;
		portRead(reply, CMD_LEN);
		}
 * 30-SEP-2010 */
	if (all[0]) {
		noChange = 0;
		sprintf(cmd, "10%s", all);
		if (portWrite(cmd, 0, 0))
			return;
		portRead(reply, CMD_LEN);
		}
	if (noChange)
		logAdd("No register changed; skipping write", 0, 0);

}

void CTabRegisters::OnRGDefaults() 
{
	m_sRGCircStatus = "01";
	m_sRGISOCtrl = "02";
	m_sRGISOMode1 = "00";
	m_sRGISOMode2 = "00";
	m_sRGTXTimerH = "C2";
	m_sRGTXTimerL = "00";
	m_sRGTXPulseLen = "00";
	m_sRGRXNRWait = "0E";
	m_sRGRXWait = "1F";
	m_sRGModulator = "11";
	m_sRGRXSpecial = "40";
	m_sRGRegulator = "87";
	m_sRGIRQ = "00";
	m_sRGOscInt = "3E";
	m_sRGCollision = "00";
	m_sRGRSSI = "0.0.0";
	m_sRGTest1 = "00";
	m_sRGTest2 = "00";
	m_sRGFIFO = "00";
	m_sRGTXLen1 = "00";
	m_sRGTXLen2 = "00";
	m_sRGFIFOwl = "00";
	m_sRGnfcLowField = "00";
	m_sRGnfcID = "000000000000000000000000";
	m_sRGnfcTargetLevel = "00";
	m_sRGnfcTargetProt = "00";
	m_sRGFIFOwl = "00";
	m_sRGnfcLowField = "00";
	m_sRGnfcID = "00";
	m_sRGnfcTargetLevel = "00";
	m_sRGnfcTargetProt = "00";
	UpdateData(FALSE);	// Set screen values
	OnRGWrite();
}

void registersNFCSetup()
{
	regDialog->NFCSetup();
}
