// TabTest.cpp : implementation file
//
/////////////////////////////////////////////////////
// This file is part of an RFID GUI. It is distributed as is
// and Texas Instruments does not provide any support.
// It is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
/////////////////////////////////////////////////////
// ShreHarsha Rao
/////////////////////////////////////////////////////

#include "stdafx.h"
#include "RFIDread.h"
#include "TabTest.h"
#include <fstream>
#include <iostream>
#include <iomanip>
#include <windows.h>
//#include <winable.h>
#include <math.h>
using namespace std;

#pragma warning(disable: 4996)

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define EXPERT	1
#define PRE_RELEASE	0
#define MAX_LINE	1024
#define MAX_LINES	64
#define MAX_LABEL	256
#define MAX_GOTO	(2 * MAX_LABEL)
#define MAX_ERRLEN	512
#define INIT_TP_SIZE	2048
#define TP_STACK_SIZE	10
#define TP_MAX_FILE	64
#define MAX_PATTERN	64
#define DIGI_PACK	1
#define MAX_O_PATTERN	(2 * MAX_PATTERN + 1)
#define LAST_XRF	-2
#define EMPTY_XRF	-1
#define SIGT_AT_END	1
#define	SMP_WRITE	10
#define	TIMER_SET_POS	2
#define	TIMER_GET_POS	3
#define	TIMER_CLOSE	4

typedef struct {
	char	id[64];
	char	fname[512];
	int	start;
	int	end;
	int	number;
	} TPFiles;
static TPFiles tpFiles[TP_MAX_FILE];
static char **testProgram;
static int tpSize = 0, tpLen = 0, tpFileCnt = 0, tpErr = 0,
		digiTimeout, digiPackLen;
static char *modules[] = {	"15693",
				"14443A",
				"14443B",
				"SR176",
				"TAGIT",
				"FELICA",
				"EPC",
				"NFC",
				NULL};
static int (*parsers[])(int, char *, char *, int, char *) = {
				parse15693,
				parse14443A,
				parse14443B,
				parseTagit,
				parseFeliCa,
				parseEPC,
				parseNFC,
				0};
static void (*tabs[])() = {
//				tabSet15,
				NULL};


#define	COMMENT	-2
#define	CONT	0
#define	DEMO	1
#define	ERRSTR	2
#define	GOTO	3
#define	INCLUDE	4
#define	INFO	5
#define	INITERRCNT	6
#define	LABEL	7
#define	MATH	8
#define	MODULE	9
#define	MOVETO	10
#define	ONERROR	11
#define	QUIET	12
#define	RECONNECT	13
#define	REPEAT	14
#define	REPORT	15
#define	SAMPLE	16
#define	SEND	17
#define	SEND_RAW	18
#define	SHOWERR	19
#define	STAT	20
#define	TITLE	21
#define	WAIT	22
#define	XCEL	23
#define	BERI	24
#define	BERI2	25
#define	BERI3	26
#define	DIGITST	27
#define	DSET	28

static char *commands[] = {	"continue",
				"demo",
				"error",
				"goto",
				"include",
				"info",
				"init_errcnt",
				"label",
				"math",
				"module",
				"moveto",
				"onerror",
				"quiet",
				"reconnect",
				"repeat",
				"report",
				"sample",
				"send",
				"send_raw",
				"showerr",
				"stat",
				"title",
				"wait",
				"xcel",
				"?",
				"??",
				"?-",
				"digitest",
				"digiset",
				NULL};
#define D_TIMEOUT	0
#define D_NLINES	1

static char *dataKeys[] = {	"timeout",
				"nlines",
				NULL};

typedef struct {
	char	*label;
	int	pos;
	int	fileNo;
	int	limit;
	int	val;
	char	*root;
	char	*what;
	} Charint;
Charint	labels[MAX_LABEL], errCounters[MAX_LABEL], repeats[MAX_LABEL];
int labelCnt = 0, errCounterCnt = 0, repeatCnt;

CString  comPort = "COM1", tTTimeout, tTNLines;
BOOL expert = 0, demo = 0;
static char demoReplyB[CMD_LEN];
char *demoReply = demoReplyB;
int logIO = 1;
int portReadMode = 0, portReadCount = 0;		// readMode
static int makeDigitest(char *, ofstream *, int, int *);
static void getTPErrors(char *csvErrors, int firstCSV);
static char xcelTLine[512], xcelLLine[512], xcelLine[512];
static char digiTPath[256];
static int isSPDemo = 0;
static int reporting = 0, sampleNo = -2, sampleErrorCnt = 0;
static int digiCancel = 0;

/////////////////////////////////////////////////////////////////////////////
// CTabTest dialog

// make it avalable to external functions:
static CTabTest *thisDialog;


CTabTest::CTabTest(CWnd* pParent /*=NULL*/)
	: CDialog(CTabTest::IDD, pParent)
{
	//{{AFX_DATA_INIT(CTabTest)
	m_sTCurrentTP = _T("");
	m_bTSPDemo = FALSE;
	m_sTString = _T("");
	m_sTSample = _T("");
	m_sTTimeout = _T("1");
	m_sTNLines = _T("4");
	m_sTErrors = _T("");
	m_bTExpert = FALSE;
	m_bTEcho = FALSE;
	//}}AFX_DATA_INIT
	thisDialog = this;
}


void CTabTest::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTabTest)
	DDX_Text(pDX, IDC_T_CURR_TP, m_sTCurrentTP);
	DDX_Check(pDX, IDC_T_SP_DEMO, m_bTSPDemo);
	DDX_Text(pDX, IDC_T_STRING, m_sTString);
	DDX_Text(pDX, IDC_T_SAMPLE, m_sTSample);
	DDX_Text(pDX, IDC_T_DIGI_TO, m_sTTimeout);
	DDX_Text(pDX, IDC_T_DIGI_NL, m_sTNLines);
	DDX_Text(pDX, IDC_T_DIGI_ERR, m_sTErrors);
	DDX_Check(pDX, IDC_T_EXPERT, m_bTExpert);
	DDX_Check(pDX, IDC_T_ECHO, m_bTEcho);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CTabTest, CDialog)
	//{{AFX_MSG_MAP(CTabTest)
	ON_BN_CLICKED(IDC_T_NEW_TP, OnTNewTp)
	ON_BN_CLICKED(IDC_T_RUN_TP, OnTRunTp)
	ON_BN_CLICKED(IDC_T_SEND, OnTSend)
	ON_BN_CLICKED(IDC_T_SEND_RAW, OnTSendRaw)
	ON_BN_CLICKED(IDC_T_EXPERT, OnTExpert)
	ON_BN_CLICKED(IDC_T_ECHO, OnTEcho)
	ON_BN_CLICKED(IDC_T_DIGI_TEST, OnTDigitest)
	ON_BN_CLICKED(IDC_T_DIGI_CANCEL, OnTDigiCancel)
	ON_BN_CLICKED(IDC_FIRMVER, OnFirmver)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTabTest message handlers
BOOL CTabTest::OnInitDialog() 
{
	GetDlgItem(IDC_T_SP_DEMO)->ShowWindow(SW_HIDE);
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CTabTest::testResetTab() 
{
	UpdateData(TRUE);	// Get curret values from the screen
#if DIGITEST
	GetDlgItem(IDC_T_DIGI_TEST)->ShowWindow(SW_SHOWNA);
	GetDlgItem(IDC_T_DIGI_ERR)->ShowWindow(SW_SHOWNA);
	GetDlgItem(IDC_T_DIGI_CANCEL)->ShowWindow(SW_SHOWNA);
#else
	GetDlgItem(IDC_T_DIGI_FRAME)->ShowWindow(SW_HIDE);
	GetDlgItem(IDC_T_DIGI_TEST)->ShowWindow(SW_HIDE);
	GetDlgItem(IDC_T_DIGI_TO_T)->ShowWindow(SW_HIDE);
	GetDlgItem(IDC_T_DIGI_TO)->ShowWindow(SW_HIDE);
	GetDlgItem(IDC_T_DIGI_NL_T)->ShowWindow(SW_HIDE);
	GetDlgItem(IDC_T_DIGI_NL)->ShowWindow(SW_HIDE);
	GetDlgItem(IDC_T_DIGI_ERR_T)->ShowWindow(SW_HIDE);
	GetDlgItem(IDC_T_DIGI_ERR)->ShowWindow(SW_HIDE);
	GetDlgItem(IDC_T_DIGI_CANCEL)->ShowWindow(SW_HIDE);
#endif
#if ! EXPERT
	GetDlgItem(IDC_T_EXPERT)->ShowWindow(SW_HIDE);
#endif
	GetDlgItem(IDC_T_ECHO)->ShowWindow(SW_HIDE);
#if 1
	GetDlgItem(IDC_T_SAMPLE_T)->ShowWindow(SW_HIDE);
	GetDlgItem(IDC_T_SAMPLE)->ShowWindow(SW_HIDE);
#endif
	UpdateData(FALSE);	// Set screen values
}


void testResetTab() 
{
	thisDialog->testResetTab();
}


int lookup (char *str, char **table)
{
	if (*str == '#')	return -2;
	char **t;
	int index;
	for (index = 0, t = table; *t; t++, index++) {
		if (! strcmp(str, *t))	return index;
		}
	return -1;
}


int getWord (char **str, char *word, char *key, int *err,
						char *fn, int ln, CString *msg)
{
	char *p, *d;
	p = *str;
	while (isspace(*p) || *p == ',')	p++;
	*str = p;
	if (! *p) {
		msg->Format("Short '%s' (%s:%d)", key, fn, ln);
		*err++;
		return 1;
		}
	if (*p == '"' || *p == '\'') {
		p++;
		for (d = word; *p && *p != '\'' && *p != '"'; )	*d++ = *p++;
		}
	else {
		for (d = word; *p && ! isspace(*p) && *p != ','; )	*d++ = *p++;
		}
	*d = 0;
	*str = p;
	return 0;
}


int maskWord (char *word, char *mask, char op)
{
	char result[MAX_LABEL], ws[4], ms[4], rs[4], *p, *m;
	int wi, mi, x;
	/* pad mask with '0' */
	ws[3] = ms[3] = result[0] = 0;
	for (p = word, m = mask; *p; m += 2, p += 2) {
		ws[0] = *p; ws[1] = *(p+1); ms[0] = *p; ms[1] = *(p+1);
		sscanf(ws, "%x", &wi);
		sscanf(ms, "%x", &mi);
		if (op == '|')	x = wi | mi;
		if (op == '&')	x = wi & mi;
		if (op == '^')	x = wi ^ mi;
		sprintf(rs, "%2.2X", x);
		strcat(result, rs);
		}
	strcpy(word, result);
	return 0;
}


static int getWordQuiet (char **str, char *word)
{
	char *p, *d;
	p = *str;
	while (isspace(*p) || *p == ',')	p++;
	if (! *p)
		return 1;
	for (d = word; *p && ! isspace(*p) && *p != ','; )	*d++ = *p++;
	*d = 0;
	*str = p;
	return 0;
}


void CTabTest::OnTNewTp() 
{
	char *types = "Test Program (*.tp)|*.tp|All Files (*.*)|*.*||";
	CFileDialog m_ldFile(TRUE, "*.tp", NULL, 0, types);
//	CFileDialog m_ldFile(TRUE);

	// Show the File open dialog and capture the result
	if (m_ldFile.DoModal() != IDOK)
		return;
	// Get the selected filename
	CString cs = m_ldFile.GetPathName();
	int i;
	m_sTCurrentTP = cs;
	UpdateData(FALSE);	// Set screen values
	demo = 0;
	isSPDemo = 0;
	GetDlgItem(IDC_T_SP_DEMO)->ShowWindow(SW_HIDE);
	UpdateData(FALSE);	// Set screen values

	// Open current test program file
	int tpStackDepth = 0;
	ifstream zz, tf, *tpp;
	ifstream tpStack[TP_STACK_SIZE];
	tpp = tpStack;
	char pathStack[TP_STACK_SIZE][256], idStack[TP_STACK_SIZE][64], *path;
	path = pathStack[tpStackDepth];
	strcpy(path, m_sTCurrentTP.GetBuffer(0));
	tpFileCnt = 0;
	if (tpFileCnt >= TP_MAX_FILE) {
		return;
		}
	strcpy(tpFiles[tpFileCnt].fname, path);
	tpFiles[tpFileCnt].start = 0, tpFiles[tpFileCnt].end = -1;
	tpFiles[tpFileCnt++].number = 0;
	tpp->open(path);
	if (tpp->fail()) {
		MessageBox("Can not open " + m_sTCurrentTP);
		return;
		}
	if (tpp->bad()) {
		MessageBox("Can not open " + m_sTCurrentTP);
		return;
		}
	int linenoStack[TP_STACK_SIZE], lineno = 0;
	int gotoCnt = 0, err = 0, fatal = 0, cmd, fileNo, haveMask, found, hasTO = 0;
	char line[MAX_LINE], reply[CMD_LEN], word[MAX_LABEL], mask[MAX_LABEL],
// zxz[256],
		 tmp[256], *start, *p, *p2, *d, *l, **t;
	Charint gotos[MAX_GOTO];
	CString msg;
	int (*moduleParser)(int, char *, char *, int, char *) = 0;
	for (i = 0; i < labelCnt; i++) {
		free(labels[i].label);
		}
	for (i = 0; i < errCounterCnt; i++) {
		free(errCounters[i].label);
		if (errCounters[i].root)
			free(errCounters[i].root);
		if (errCounters[i].what)
			free(errCounters[i].what);
		errCounters[i].root = 0;
		errCounters[i].what = 0;
		}
	labelCnt = 0;
	errCounterCnt = 0;
	tpLen = 0;
	t = testProgram;
	fileNo = 0;

	while (tpp->eof() == 0 && ! fatal) {
	  more:
		tpp->getline(line, MAX_LINE, '\n');
		if ((i = strlen(line)) >= (MAX_LINE-1)) {
			msg.Format("Line too long. Aborting (%s:%d)",
							path, lineno);
			MessageBox(msg, "", MB_OK);
			return;
			}
		lineno++;
		p = line;
		while (isspace(*p))	p++;
/*
		if (*p == '#')	continue;	// comment line
 */
		start = p;
		p++;
		if ((p = strchr(p, '#')))	*p = 0;	// inline comment
		p = start;
		p += strlen(p) - 1;		// remove trailing spaces
		while (isspace(*p))	p--;
		p++;
		*p = 0;
		if (! strlen(start))	continue;	// empty line
		p = start;
		if (getWord(&p, word, "command", &err, path, lineno, &msg)) {
			MessageBox(msg, "", MB_OK);
			}
		while (isspace(*p))	p++;
		cmd = lookup(word, commands);
		if (cmd == -1 && ! moduleParser) {
			msg.Format("Invalid keyword '%s' (%s:%d)",
							word, path, lineno);
			MessageBox(msg, "", MB_OK);
			err++;
			continue;
			}
// sprintf(zxz, "%d :: %s", tpLen, start);
// logAdd(zxz, 1, 0);
		switch (cmd) {
		  case CONT:
			if (getWord(&p, word, commands[cmd], &err,
							path, lineno, &msg))
				MessageBox(msg, "", MB_OK);
			break;
		  case DEMO:
			demo = 1;
			break;
		  case ERRSTR:
			if (strlen(p) > MAX_ERRLEN) {
				msg.Format("Warning too long (%s:%d)",
							path, lineno);
				MessageBox(msg, "", MB_OK);
				err++;
				}
			if (getWord(&p, word, commands[cmd], &err,
							path, lineno, &msg))
				MessageBox(msg, "", MB_OK);
			break;
		  case GOTO:
			(void) getWord(&p, word, commands[cmd], &err,
							path, lineno, &msg);
			if (gotoCnt >= MAX_LABEL) {
				msg.Format("Too many gotos at '%s' (%s:%d)",
							word, path, lineno);
				MessageBox(msg, "", MB_OK);
				continue;
				err++;
				}
			gotos[gotoCnt].label = strdup(word);
			gotos[gotoCnt].pos = lineno;
			gotos[gotoCnt].fileNo = fileNo;
			gotoCnt++;
			break;
		  case INCLUDE:
			tpStackDepth++;
			if (tpStackDepth >= TP_STACK_SIZE) {
				msg.Format("Too many levels of include '%s' (%s:%d)",
							word, path, lineno);
				MessageBox(msg, "", MB_OK);
				return;
				}
			while (isspace(*p))	p++;
			tpFiles[tpFileCnt].id[0] = 0;
			if (*p == '<') {
				p++;
				for (d = word;
					*p && ! isspace(*p) && *p != '>';  )
					*d++ = *p++;
				*d = 0;
				strcpy(tpFiles[tpFileCnt].id, word);
				p++;
				}
			if (getWord(&p, word, commands[cmd], &err,
							path, lineno, &msg))
				MessageBox(msg, "", MB_OK);
			strcpy(pathStack[tpStackDepth], path);
			strcpy(idStack[tpStackDepth], tpFiles[tpFileCnt].id);
			path = pathStack[tpStackDepth];
			p2 = strrchr(path, '\\');
			p2++;
			*p2 = 0;
			strcat(path, word);
			strcpy(tpFiles[tpFileCnt].fname, path);
			tpFiles[tpFileCnt].start = tpLen;
			tpFiles[tpFileCnt].end = -1;
			tpFiles[tpFileCnt].number = tpFileCnt;
			fileNo = tpFiles[tpFileCnt].number;
			tpFileCnt++;
			tpp++;
			tpp->open(path, ios::in);
			if (tpp->bad()) {
				msg.Format("Can not open '%s' (%s:%d)",
							word, path, lineno);
				MessageBox(msg);
				return;
				}
			if (tpp->fail()) {
				msg.Format("Can not open '%s' (%s:%d)",
							word, path, lineno);
				MessageBox(msg);
				return;
				}
			linenoStack[tpStackDepth-1] = lineno;
			lineno = 0;
			continue;
		  case INFO:
			if (getWord(&p, word, commands[cmd], &err,
							path, lineno, &msg))
				MessageBox(msg, "", MB_OK);
			p = line;
			p2 = p;
			p2 += strlen(commands[cmd]);
			while (isspace(*p2))	p2++;
			if (*p2 == '<' && isdigit(*(p2+1)))	hasTO = 1;
			p += strlen(line) - 1;
			while (*p == '+') {
				*p = 0;
				tpp->getline(reply, MAX_LINE, '\n');
				lineno++;
				p = reply;
				while (isspace(*p))	p++;
				strcat(line, "\n");
				if (*p == '+')	strcat(line, "   ");
				strcat(line, p);
				p = line;
				p += strlen(line) - 1;
				}
			break;
		  case INITERRCNT:
			if (getWord(&p, word, commands[cmd], &err,
							path, lineno, &msg))
				MessageBox(msg, "", MB_OK);
			if (errCounterCnt >= MAX_LABEL) {
				msg.Format(
				"Too many error counters at '%s' (%s:%d)",
							word, path, lineno);
				MessageBox(msg, "", MB_OK);
				continue;
				err++;
				}
			tmp[0] = 0;
			for (i = 1; i <= tpStackDepth; i++) {
				if (idStack[i][0]) {
					strcat(tmp, idStack[i]);
					strcat(tmp, ".");
					}
				}
			for (i = 0; i < errCounterCnt; i++)
				if (! strcmp(word, errCounters[i].label) &&
				     (tpFileCnt - 1) == errCounters[i].fileNo)
					break;
			if (i < errCounterCnt &&
					! strcmp(word, errCounters[i].label)) {
				/* Nothing */
				}
			else {
				errCounters[errCounterCnt].label = strdup(word);
				errCounters[errCounterCnt].pos = tpLen;
				errCounters[errCounterCnt].fileNo = tpFileCnt-1;
				errCounters[errCounterCnt].root = strdup(tmp);
				errCounters[errCounterCnt].what = 0;//strdup("=UNUSED=");
				errCounterCnt++;
				}
			break;
		  case LABEL:
			if (getWord(&p, word, commands[cmd], &err,
							path, lineno, &msg)) {
				MessageBox(msg, "", MB_OK);
				continue;
				}
			if (labelCnt >= MAX_LABEL) {
				msg.Format("Too many labels at '%s' (%s:%d)",
							word, path, lineno);
				MessageBox(msg, "", MB_OK);
				continue;
				err++;
				}
			for (i = 0; i < labelCnt; i++)
				if (! strcmp(word, labels[i].label) &&
					(tpFileCnt - 1) == labels[i].fileNo)
					break;
			if (i < labelCnt && ! strcmp(word, labels[i].label)) {
				msg.Format("Label %s redefined (%s: %d)",
							word, path, lineno);
				MessageBox(msg, "", MB_OK);
				err++;
				}
			else {
				labels[labelCnt].label = strdup(word);
				labels[labelCnt].pos = tpLen;
				labels[labelCnt].fileNo = fileNo;
				labelCnt++;
				}
			continue;
		  case MATH:
			// get first value
			if (getWord(&p, word, commands[cmd], &err,
							path, lineno, &msg))
				MessageBox(msg, "", MB_OK);
			if (strcmp(word, "!")) {
				msg.Format("Invalid first operand '%s' (%s:%d)",
							word, path, lineno);
				MessageBox(msg, "", MB_OK);
				err++;
				fatal = 1;
				}
			// get operator
			if (getWord(&p, word, commands[cmd], &err,
							path, lineno, &msg))
				MessageBox(msg, "", MB_OK);
			if (strlen(word) != 1 ||
			    (word[0] != '|' && word[0] != '&')) {
				msg.Format("Invalid operator '%s' (%s:%d)",
							word, path, lineno);
				MessageBox(msg, "", MB_OK);
				err++;
				fatal = 1;
				}
			// get last value
			if (getWord(&p, word, commands[cmd], &err,
							path, lineno, &msg))
				MessageBox(msg, "", MB_OK);
			if (sscanf(word, "%x", &i) != 1) {
				msg.Format("Invalid second operand '%s' (%s:%d)",
							word, path, lineno);
				MessageBox(msg, "", MB_OK);
				err++;
				fatal = 1;
				}
			break;
		  case MODULE:
			if (getWord(&p, word, commands[cmd], &err,
							path, lineno, &msg))
				MessageBox(msg, "", MB_OK);
			cmd = lookup(word, modules);
			if (cmd == -1) {
				msg.Format("Invalid module '%s' (%s:%d)",
							word, path, lineno);
				MessageBox(msg, "", MB_OK);
				err++;
				fatal = 1;
				}
			moduleParser = parsers[cmd];
			break;
		  case MOVETO:
			if (getWord(&p, word, commands[cmd], &err,
							path, lineno, &msg))
				MessageBox(msg, "", MB_OK);
			if (! isdigit(word[0])) {
				msg.Format("Number expected '%s' (%s:%d)",
						commands[cmd], path, lineno);
				MessageBox(msg, "", MB_OK);
				err++;
				}
			if (getWord(&p, word, commands[cmd], &err,
							path, lineno, &msg))
				MessageBox(msg, "", MB_OK);
			if (! isdigit(word[0])) {
				msg.Format("Two numbers expected '%s' (%s:%d)",
						commands[cmd], path, lineno);
				MessageBox(msg, "", MB_OK);
				err++;
				}
			break;
		  case ONERROR:
			while (isspace(*p))	p++;
			if (! *p)	break;
			if (! getWord(&p, word, commands[cmd], &err,
							path, lineno, &msg))
				break;
			if (gotoCnt >= MAX_LABEL) {
				msg.Format("Too many gotos at '%s' (%s:%d)",
							word, path, lineno);
				MessageBox(msg, "", MB_OK);
				continue;
				err++;
				}
			gotos[gotoCnt].label = strdup(word);
			gotos[gotoCnt].pos = lineno;
			gotos[gotoCnt].fileNo = fileNo;
			gotoCnt++;
			if (strlen(word) > MAX_ERRLEN) {
				msg.Format("Address too long (%s:%d)",
								path, lineno);
				MessageBox(msg, "", MB_OK);
				err++;
				}
			while (isspace(*p))	p++;
			if (*p && strlen(p) > MAX_ERRLEN) {
				msg.Format("Warning too long (%s:%d)",
								path, lineno);
				MessageBox(msg, "", MB_OK);
				err++;
				}
			break;
		  case QUIET:
			break;
		  case RECONNECT:
			break;
		  case REPEAT:
			if (getWord(&p, word, commands[cmd], &err,
							path, lineno, &msg))
				MessageBox(msg, "", MB_OK);
			if (gotoCnt >= MAX_LABEL) {
				msg.Format("Too many labels at '%s' (%s:%d)",
							word, path, lineno);
				MessageBox(msg, "", MB_OK);
				continue;
				err++;
				}
			gotos[gotoCnt].label = strdup(word);
			gotos[gotoCnt].pos = lineno;
			gotos[gotoCnt].fileNo = fileNo;
			gotoCnt++;
			repeats[repeatCnt].label = strdup(word);
			repeats[repeatCnt].pos = lineno;
			repeats[repeatCnt].val = -1;
			repeats[repeatCnt].fileNo = fileNo;
			repeatCnt++;
			if (getWord(&p, word, commands[cmd], &err,
							path, lineno, &msg))
				MessageBox(msg, "", MB_OK);
			if (! isdigit(word[0])) {
				msg.Format("Number expected '%s' (%s:%d)",
						commands[cmd], path, lineno);
				MessageBox(msg, "", MB_OK);
				err++;
				}
			break;
		  case REPORT:
			break;
		  case SAMPLE:
			if (! strncmp(p, "new", 3) && sampleNo < 0) {
				sampleNo = 1;
				tf.open("URFID-sample-no.txt", ios::in);
				if (tf.good()) {
					tf.getline(tmp, 64, '\n');
					sampleNo = atoi(tmp);
					}
				m_sTSample.Format("%d", sampleNo);
				UpdateData(FALSE);	// Set screen values
				sampleErrorCnt = 0;
				}
			break;
		  case SEND:
		  case SEND_RAW:
			if (getWord(&p, word, commands[cmd], &err,
							path, lineno, &msg))
				MessageBox(msg, "", MB_OK);
			break;
		  case SHOWERR:
			if (getWord(&p, word, commands[cmd], &err,
							path, lineno, &msg))
				MessageBox(msg, "", MB_OK);
			for (i = 0; i < errCounterCnt; i++) {
				if (! strcmp(word, errCounters[i].label) &&
					errCounters[i].fileNo == tpFileCnt-1) {
					found = 1;
					break;
					}
				}
			if (! found) {
				msg.Format(
				"Undefined error counter '%s' (%s:%d)",
							word, path, lineno);
				MessageBox(msg, "", MB_OK);
				}
			while (isspace (*p))	p++;
			if (*p == '<') {
				p++;
				(void) getWordQuiet(&p, word);
				errCounters[i].limit = atoi(word);
				while (isspace (*p))	p++;
				}
			errCounters[i].what = strdup(p);
			break;
		  case STAT:
			break;
		  case TITLE:
			break;
		  case WAIT:
			if (getWord(&p, word, commands[cmd], &err,
							path, lineno, &msg))
				MessageBox(msg, "", MB_OK);
			if (! isdigit(word[0])) {
				msg.Format("Number expected '%s' (%s:%d)",
						commands[cmd], path, lineno);
				MessageBox(msg, "", MB_OK);
				err++;
				}
			break;
		  case XCEL:
			break;
		  case BERI:
			haveMask = 0;
			if (p2 = strpbrk(p, "|&^")) {
				if (getWord(&p, mask, "verify mask", &err,
							path, lineno, &msg)) {
					MessageBox(msg, "", MB_OK);
					break;
					}
				i = strlen(mask);
				if (i % 2) {
					msg.Format("Mask - expecting even number of characters (%s:%d)", path, lineno);
					MessageBox(msg, "", MB_OK);
					err++;
					}
				haveMask = 1;
				p = p2;
				p++;
				}
			if (getWord(&p, word, commands[cmd], &err,
							path, lineno, &msg))
				MessageBox(msg, "", MB_OK);
			if (haveMask && strlen(word) != strlen(mask)) {
				msg.Format("Mask and target must be of the same length (%s:%d)", path, lineno);
				MessageBox(msg, "", MB_OK);
				err++;
				}
			break;
		  case BERI2:
		  case BERI3:
			if (getWord(&p, word, commands[cmd], &err,
							path, lineno, &msg))
				MessageBox(msg, "", MB_OK);
			break;
		  case DIGITST:
			if (getWord(&p, word, commands[cmd], &err,
							path, lineno, &msg))
				MessageBox(msg, "", MB_OK);
			break;
		  case COMMENT:
			break;
		  case DSET:
			if (getWord(&p, word, commands[cmd], &err, path, lineno, &msg)) {
				hopa(msg);
				return;
				}
			cmd = lookup(word, dataKeys);
			if (cmd == -1) {
				msg.Format("Invalid data '%s' in line %d",
								word, lineno);
				hopa(msg);
				return;
				}
			if (getWord(&p, word, "data value",
						&err, path, lineno, &msg)) {
				hopa(msg);
				return;
				}
			break;
		  default:
			moduleParser(0, line, path, lineno, reply);
		  }

		if (tpLen >= tpSize) {
			if (tpSize == 0) {
				testProgram = new (char * [INIT_TP_SIZE]);
				tpSize = INIT_TP_SIZE;
				t = testProgram;
				}
			else {
				MessageBox("Huge test program", "", MB_OK);
				err = 1;
				break;
				}
			}
		l = strdup(start);
		strcpy(l, start);
		*t++ = l;
		tpLen++;
		}
	int ok, j;
	for (j = 0; j < tpFileCnt; j++) {
		if (! strcmp(tpFiles[j].fname, path) &&
			tpFiles[j].number == fileNo)	break;
		}
	tpFiles[j].end = tpLen-1;
	tpp->close();
	tpp->clear();
	if (tpStackDepth) {
		tpStackDepth--;
		tpp--;
		path = pathStack[tpStackDepth];
		lineno = linenoStack[tpStackDepth];
		fileNo = tpFiles[tpStackDepth].number;
		goto more;
		}
	for (i = 0; i < gotoCnt; i++) {
		for (ok = 0, j = 0; j < labelCnt; j++) {
			if (! strcmp(gotos[i].label, labels[j].label) &&
					gotos[i].fileNo == labels[j].fileNo) {
				ok = 1;
				break;
				}
			}
		if (! ok) {
			msg.Format("Missing label for goto %s (%s)",
							 gotos[i].label, path);
			MessageBox(msg);
			err++;
			}
		}
	if (err) {
		msg.Format("Summary: %d errors found.", err);
		MessageBox(msg);
		for (t = testProgram, i = 0; i < tpLen; i++, t++)
			delete *t;
		tpLen = 0;
		}
//	for (t = testProgram, i = 0; i < tpLen; i++, t++)
//		z = *t;
//		MessageBox(*t);
	if (demo && hasTO) {
		GetDlgItem(IDC_T_SP_DEMO)->ShowWindow(SW_SHOWNA);
		m_bTSPDemo = TRUE;
		UpdateData(FALSE);	// Set screen values
		isSPDemo = 1;
		}
}


static char *ascii2hex(char *str)
{
	char tmp[4], *p;
	static char buf[256];
	for (buf[0] = 0, p = str; *p; p++) {
		sprintf(tmp, "%2.2X", *p);
		strcat(buf, tmp);
		}
	return buf;
}


void testReportAdd(char *str)
{
	if (! reporting)	return;
	static ofstream rep;
	static int isOpen = 0;
	if (! isOpen)
		rep.open("URFID-report.txt", ios::app);
	isOpen = 1;
	rep << str << endl;
}


void CALLBACK timerF(HWND w, UINT message, UINT id, DWORD t) 
{
	static int ulx = -1, uly = -1, brx, bry;
	if (id == TIMER_CLOSE) {
		KillTimer(w, TIMER_CLOSE);
		CWnd *mb = CWnd::FindWindow("#32770", "Info");
		if (mb)	{
			mb->SetForegroundWindow();
//			SendKeys("{enter}");
//			mouse_event(MOUSEEVENT_LEFTDOWN, 100,100,0,0);
			keybd_event(VK_RETURN, 0x1C,
				KEYEVENTF_EXTENDEDKEY | 0, 0);
			keybd_event(VK_RETURN, 0x1C,
				KEYEVENTF_EXTENDEDKEY | KEYEVENTF_KEYUP, 0);
//			EndDialog((HWND) mb, IDOK);
//			mb->DestroyWindow();
			}
//		mb = CWnd::FindWindow("#32770", "SAL EVM Control");
//		if (mb)	{
//			mb->SetForegroundWindow();
//			mb->SetFocus();
//			}
		}
	if (id == TIMER_GET_POS) {
		CWnd *mb = CWnd::FindWindow("#32770", "Info");
		if (mb) {
			RECT r;
			mb->GetWindowRect(&r);
			ulx = r.left, uly = r.top;
			brx = r.right, bry = r.bottom;
			}
		}
	if (id == TIMER_SET_POS) {
		KillTimer(w, TIMER_SET_POS);
		CWnd *mb = CWnd::FindWindow("#32770", "Info");

		if (mb && ulx != -1)
			mb->SetWindowPos(&CWnd::wndTop, ulx, uly,
						FALSE, FALSE, SWP_NOSIZE);
		}
}

#if 0
void MouseMove (int x, int y )
{  
  double fScreenWidth    = ::GetSystemMetrics( SM_CXSCREEN )-1; 
  double fScreenHeight  = ::GetSystemMetrics( SM_CYSCREEN )-1; 
  double fx = x*(65535.0f/fScreenWidth);
  double fy = y*(65535.0f/fScreenHeight);
  INPUT  Input={0};
  Input.type      = INPUT_MOUSE;
  Input.mi.dwFlags  = MOUSEEVENTF_MOVE|MOUSEEVENTF_ABSOLUTE;
  Input.mi.dx = fx;
  Input.mi.dy = fy;
  SendInput(1,&Input,sizeof(INPUT));
}
#endif


void closeSample()
{
	char msg[256];
	sprintf(msg, "\t\t\t==== SAMPLE %3d =====================", sampleNo);
	logAdd(msg, 0, 0);
	testReportAdd(msg);
	sprintf(msg, "\t\t\t=\t\t\t%5d errors  =", sampleErrorCnt);
	logAdd(msg, 0, 0);
	testReportAdd(msg);
	sprintf(msg, "\t\t\t=====================================");
	logAdd(msg, 0, 0);
	testReportAdd(msg);
	strcpy(msg, "");
	logAdd(msg, 0, 0);
	testReportAdd(msg);
}


int firstCSV = 1;
void CTabTest::OnTRunTp() 
{
	// Run test program
	tpErr = 0;
	char word[260], word2[260], mask[260], errorString[MAX_ERRLEN],
		onerrorLabel[MAX_ERRLEN], onerrorString[MAX_ERRLEN],
		title[256], csvErrors[1024], root[256],
//		ascii[8], tmp[16],
		reply[CMD_LEN], echo[CMD_LEN], gotolab[64], *errMarker = "*** ",
		op, **t, *p, *p2, *rb, *re;
	int pos, cmd, answer, more, haveMask, tooBad, quiet = 0, statistics = 0,
		mathVal = 0, cmd0 = -99, fileNo, close, cnt, ok, skipTO = 0,
		i, j, k, n;
	CString msg, data;
	int (*moduleParser)(int, char *, char *, int, char *) = 0;
	ofstream out, xcel, tf;
	Charint *currentErrCounter = 0;
	int tpStackDepth = 0;
	struct {
	    int cnt;
	    int no;
	    } pathError[TP_STACK_SIZE];
	title[0] = 0;
	errorString[0] = 0;
	onerrorLabel[0] = 0;
	onerrorString[0] = 0;
	UpdateData(TRUE);	// Get curret values from the screen
	sampleNo = atoi(m_sTSample.GetBuffer(0));
	if (sampleNo < 1)	sampleNo = 1;
	skipTO = 0;
	if (isSPDemo && ! m_bTSPDemo)	skipTO = 1;
	CWnd *mw;

	for (t = testProgram, pos = 0; pos < tpLen; pos++, t++) {
		for (i = 0; i < tpFileCnt; i++)
			if (pos == tpFiles[i].start) {
				sprintf(echo, "============ Starting '%s'",
							tpFiles[i].fname);
				logAdd(echo, 0, 0);
				pathError[tpStackDepth].no = i;
				pathError[tpStackDepth].cnt = 0;
				fileNo =
				    tpFiles[pathError[tpStackDepth].no].number;
				tpStackDepth++;
				}
		p = *t;
		strcpy(echo, "... ");
		strcat(echo, p);
		if (quiet)	logAddFileOnly();
		logAdd(echo, 0, 0);
//		testReportAdd(echo);
		if (*p == '#') {
			goto checkEnd;
			}
		while (isspace(*p))	p++;
		(void) getWordQuiet(&p, word);
		while (isspace(*p))	p++;
		cmd = lookup(word, commands);
		switch (cmd) {
		  case CONT:
			p2 = p;
			(void) getWordQuiet(&p, word);
			for (i = 0; i < labelCnt; i++)
				if (! strcmp(word, labels[i].label) &&
						fileNo == labels[i].fileNo)
					break;
			if (i >= labelCnt)
				p = p2;
			if (*p) {
				if (i < labelCnt)
					answer = MessageBox(p, "Continue?", MB_YESNOCANCEL);
				else
					answer = MessageBox(p, "Continue?", MB_OKCANCEL);
				if (answer == IDCANCEL)
					return;
				if (answer == IDNO)
					break;
				}
			if (i < labelCnt) {
				pos = labels[i].pos - 1;
				t = &testProgram[pos];
				}
			break;
		  case DEMO:
			demo = 1;
			break;
		  case ERRSTR:
			strcpy(errorString, p);
			break;
		  case GOTO:
			(void) getWordQuiet(&p, word);
			for (i = 0; i < labelCnt; i++)
				if (! strcmp(word, labels[i].label) &&
					fileNo == labels[i].fileNo)	break;
			pos = labels[i].pos - 1;
			t = &testProgram[pos];
			break;
		  case INFO:
			if (*p) {
				if (*p == '<' && isdigit(*(p+1))) {
					p++;
					i = atoi(p);
					while (isdigit(*p))	p++;
					if (*p == '>')	p++;
					while (isspace(*p))	p++;
					i *= 1000;
					if (! skipTO)
					    SetTimer(TIMER_CLOSE, i, timerF);
					}
				SetTimer(TIMER_SET_POS, 10, timerF);
				SetTimer(TIMER_GET_POS, 200, timerF);
				answer = MessageBox(p, "Info", MB_OKCANCEL | MB_TASKMODAL);
				KillTimer(TIMER_GET_POS);
				if (answer == IDCANCEL)
					return;
				}
			break;
		  case INITERRCNT:
			(void) getWordQuiet(&p, word);
			for (i = 0; i < errCounterCnt; i++)
				if (! strcmp(word, errCounters[i].label) &&
					fileNo == errCounters[i].fileNo)
					break;
			errCounters[i].val = 0;
			currentErrCounter = &errCounters[i];
			break;
		  case MATH:
			// get first value
			(void) getWordQuiet(&p, word);
			if (cmd0 != MATH) {
				// extract value from the reply
				if (! (p2 = strchr(reply, '['))) {
					MessageBox("No data in the last reply");
					continue;
					}
				p2++;
				sscanf(p2, "%x", &mathVal);
				for (i = 1; ; i++) {
					p2++;
					if (! (p2 = strchr(p2, '[')))
						break;
					p2++;
					sscanf(p2, "%x", &n);
					mathVal |= n << (i * 8);
					}
				}
			(void) getWordQuiet(&p, word);
			op = word[0];
			(void) getWordQuiet(&p, word);
			sscanf(word, "%x", &i);
// sprintf(reply, "%x %c %x", mathVal, op, i);
// logAdd(reply, 0, 0);
			if (op == '&')		mathVal &= i;
			else if (op == '|')	mathVal |= i;
// sprintf(reply, "%x", mathVal);
// logAdd(reply, 0, 0);
			cmd0 = cmd;
			continue;
		  case MODULE:
			getWordQuiet(&p, word);
			cmd = lookup(word, modules);
			moduleParser = parsers[cmd];
			if (tabs[cmd])
				tabs[cmd]();
			break;
		  case MOVETO:
			if (! demo)	break;
			(void) getWordQuiet(&p, word);
			i = atoi(word);
			(void) getWordQuiet(&p, word);
			j = atoi(word);
			mw = CWnd::FindWindow("#32770",
							"SAL EVM Control");
			if (mw) {
				int px, py;
// int zx, zy;
				double dx, dy, tx, ty;
				RECT r;
				POINT p;
				mw->GetWindowRect(&r);
				GetCursorPos(&p);
				i += r.left, j += r.top,
				dx = (i - (double) p.x);
				dy = (j - (double) p.y);
				tx = sqrt(dx * dx + dy * dy);
				if (tx < 100)	k = 30;
				else if (tx < 200)	k = 50;
				else if (tx < 400)	k = 70;
				else k = 100;
				dx /= k; dy /= k;
				for (tx = p.x, ty = p.y, n = 0; n < k; n++, tx += dx, ty += dy) {
					px = (int) (tx + 0.5), py = (int) (ty + 0.5);
					SetCursorPos(px, py);
					Sleep(10);
					}
				SetCursorPos(i, j);
//				mouse_event(MOUSEEVENTF_LEFTDOWN, i,j,0,0);
//				mouse_event(MOUSEEVENTF_LEFTUP, i,j,0,0);
				INPUT Input = {0};
				Input.type = INPUT_MOUSE;
				Input.mi.dwFlags = MOUSEEVENTF_LEFTDOWN;
				SendInput(1, &Input, sizeof(INPUT));
				ZeroMemory(&Input, sizeof(INPUT));
				Input.type = INPUT_MOUSE;
				Input.mi.dwFlags = MOUSEEVENTF_LEFTUP;
				SendInput(1, &Input, sizeof(INPUT));
				}
			break;
		  case ONERROR:
			while (isspace(*p))	p++;
			if (! *p) {
			    onerrorLabel[0] = 0;
			    onerrorString[0] = 0;
			    break;
			    }
			getWordQuiet(&p, word);
			strcpy(onerrorLabel, word);
			while (isspace(*p))	p++;
			if (*p)
				strcpy(onerrorString, p);
			else
				onerrorString[0] = 0;
			break;
		  case QUIET:
			quiet = (quiet) ? 0 : 1;
			if (quiet)	logAddFileOnly();
			else		logAddFileScreen();
			break;
		  case RECONNECT:
			portReconnect();
			break;
		  case REPEAT:
			(void) getWordQuiet(&p, word);
			(void) getWordQuiet(&p, word2);
			for (i = 0; i < repeatCnt; i++)
				if (! strcmp(word, repeats[i].label))	break;
// sprintf(echo, "===================== %s %s %d (%d) - %d", word, word2, currentErrCounter->val, repeats[i].val, repeats[i].fileNo);
// logAdd(echo, 0, 0);
			if (! repeats[i].val) {
// logAdd("DOST", 0, 0);
				repeats[i].val = -1;
				break;
				}
			if (repeats[i].val == -1)
				repeats[i].val = atoi(word2) - 1;
			repeats[i].val -= 1;
//			sprintf(ascii, "%3d", repeats[i].val);
//			sprintf(echo, "90%s", ascii2hex(ascii));
//			if (portWrite(echo, 0, 0))
//				return;
//			(void) portRead(reply, CMD_LEN);
			for (i = 0; i < labelCnt; i++)
				if (! strcmp(word, labels[i].label) &&
					fileNo == labels[i].fileNo)	break;
			pos = labels[i].pos - 1;
			t = &testProgram[pos];
			break;
		  case REPORT:
			reporting = 1;
			break;
		  case SAMPLE:
			if (! strncmp(p, "new", 3)) {
sprintf(echo,"==================== SAMPLE %d =================================",
								sampleNo);
				logAdd(echo, 0, 0);
				testReportAdd(echo);
				m_sTSample.Format("%d", sampleNo);
				UpdateData(FALSE);	// Set screen values
				sampleErrorCnt = 0;
				strcpy(xcelTLine, "sample");
				strcpy(xcelLLine, "limit");
				sprintf(word, "%d", sampleNo);
				strcpy(xcelLine, word);
				}
			if (! strncmp(p, "print", 5)) {
				closeSample();
				msg.Format(
				    "Sample %d has %d error%c - check report",
					sampleNo, sampleErrorCnt,
					(sampleErrorCnt > 1) ? 's' : ' ');
				MessageBox(msg);
				sampleNo++;
				tf.open("URFID-sample-no.txt");
				tf << sampleNo << endl;
				tf.close();
				}
			break;
		  case SEND:
		  case SEND_RAW:
			if (cmd == SEND_RAW)
				(void) strcpy(word, p);
			else
				(void) getWordQuiet(&p, word);
			close = 0;
			if (! word[2] && word[0] == '0' &&
				(word[1] == 'A' || word[1] == 'B' || word[1] == 'C' ||
				 word[1] == 'a' || word[1] == 'b' || word[1] == 'c'))
				close = 1;
			if ((p = strchr(word, '!'))) {	// expand mathVal
				p2 = p;
				p2 -= 2;
				sscanf(p2, "%x", &i);
				if (i == 0x15 || i == 0x16 || i == 0x17) {
					i = mathVal;
					// swap bytes;
					mathVal = (i & 0x00FF0000) >> 16 |
							(i & 0x0000FF00) |
							(i & 0x000000FF) << 16;
// sprintf(reply, "%x -- %x", mathVal, i);
// logAdd(reply, 0, 0);
					sprintf(p, "%6.6X", mathVal);
					}
				else
					sprintf(p, "%2.2X", mathVal);
				}
//			if (portWrite(word, close, 0))
			if (cmd == SEND_RAW)
				i = portWrite(word, 9, 0);
			else
				i = portWrite(word, close, 0);
			if (i)
				return;
			if (! close)
				(void) portRead(reply, CMD_LEN);
			break;
		  case SHOWERR:
			(void) getWordQuiet(&p, word);
			for (i = 0; i < errCounterCnt; i++)
				if (! strcmp(word, errCounters[i].label) &&
					fileNo == errCounters[i].fileNo)
					break;
			p2 = "", word2[0] = 0;
			tooBad = 0;
			while (isspace (*p))	p++;
			if (*p == '<') {
				p++;
				(void) getWordQuiet(&p, word);
				tooBad = atoi(word);
				while (isspace (*p))	p++;
				}
			if (tooBad >= 0 && errCounters[i].val > tooBad) {
				p2 = errMarker;
				sprintf(word2, "(%d) ", tooBad);
				msg.Format("%s%d %s'%s'", p2,
						errCounters[i].val, word2, p);
				logAdd(msg.GetBuffer(0), 0, 0);
				testReportAdd(msg.GetBuffer(0));
				if (! quiet && ! reporting)	MessageBox(msg);
				}
			i = errCounters[i].val - tooBad;
			if (i < 0)	i = 0;
			sampleErrorCnt += i;
			break;
		  case STAT:
			statistics = (statistics) ? 0 : 1;
			errMarker = (quiet) ? "* " : "*** ";
			break;
		  case TITLE:
			if (quiet)	logAddFileScreen();
			strcpy(title, p);
			sprintf(echo, "------------------------> %s", title);
			logAdd(echo, 0, 0);
			testReportAdd(echo);
			if (quiet)	logAddFileOnly();
			break;
		  case WAIT:
			(void) getWordQuiet(&p, word);
			i = atoi(word);
			i *= 1000;	// miliseconds
			Sleep(i);
			break;
		  case XCEL:
			  if (firstCSV) {
				xcel.open("URFID-errors.csv", ios::in);
				if (xcel.good()) {
					firstCSV = 0;
					xcel.close();
					xcel.clear();
					}
				else {
					firstCSV = 1;
					xcel.clear();
					}
				}

			xcel.open("URFID-errors.csv", ios::app);
			if (firstCSV && sampleNo <= 0) {
				getTPErrors(csvErrors, -1);
				xcel << csvErrors;
				for (i = 0; i < errCounterCnt; i++)
				    xcel << errCounters[i].label << " - " <<
						errCounters[i].what << endl;
				xcel << endl;
				getTPErrors(csvErrors, firstCSV);
				xcel << "TITLE," << csvErrors;
				for (i = 0; i < errCounterCnt; i++)
					xcel << "," << errCounters[i].label;
				xcel << endl;
				firstCSV = 0;
				}
			if (firstCSV && sampleNo > 0) {
				for (i = 0; i < errCounterCnt; i++) {
					if (errCounters[i].root)
						xcel << errCounters[i].root;
				    xcel << errCounters[i].label << " - " <<
						errCounters[i].what << endl;
					}
				xcel << endl;
				xcel << xcelTLine << endl;
				xcel << xcelLLine << endl;
				}
			if (sampleNo <= 0) {
				getTPErrors(csvErrors, firstCSV);
  				xcel << title << "," << csvErrors;
				for (i = 0; i < errCounterCnt; i++)
				    xcel << "," << errCounters[i].val;
  				xcel << endl;
				}
			else
				xcel << xcelLine << endl;
			xcel.close();
			break;
		  case BERI:
			if (demo)	strcpy(reply, demoReply);
			re = reply;
			haveMask = 0;
			if (*p == '%') {
				p++;
				cnt = atoi(p);
				if (! ((rb = strchr(re, '[')) &&
					(re = strchr(rb, ']')))) {
					tooBad = 1;
					goto report2;
					}
				rb++;
				*re++ = 0;
				i = strlen(rb);
				tooBad = 0;
				if (i != cnt)	tooBad = 1;
				goto report2;
				}
			if (p2 = strpbrk(p, "|&^")) {
				haveMask = 1;
				op = *p2;
				*p2 = 0;
				if (getWordQuiet(&p, mask))
				    break;
				p = p2;
				p++;
				}
			tooBad = 0;
			cnt = -1;
			while (! getWordQuiet(&p, word)) {
				cnt++;
				more = 0;
				while ((rb = strchr(re, '[')) && (re = strchr(rb, ']')) &&
											((re - rb) == 1))
					more++/* Nothing */;	// skip empty braces []
				if (rb && re) {
					rb++;
					*re++ = 0;
					}
				// skip checking in case of '*'
				if (! strcmp(word, "*"))	continue;
				if (rb && haveMask) {
					maskWord(rb, mask, op);
					}
				if (rb && strcmp(word, rb)) {
					msg.Format("%s%s ('%s' != '%s')[%d]",
					errMarker, errorString, rb, word, cnt);
					logAdd(msg.GetBuffer(0), 0, 0);
					if (! quiet)	MessageBox(msg);
					tooBad = 1;
					}
				else if (! rb) {
					msg.Format("%s%s ('%s' expected)",
					errMarker, errorString, word);
					logAdd(msg.GetBuffer(0), 0, 0);
					if (! quiet)	MessageBox(msg);
					tooBad = 1;
					}
/* 12-OCT-05 *
				if (more) re++;
 * 12-OCT-05 */
				}
		  report2:
			if (tooBad && ! statistics)
				pathError[tpStackDepth-1].cnt += 1;
			if (tooBad && currentErrCounter)
				currentErrCounter->val += 1;
			if (tooBad && ! currentErrCounter && sampleNo >= 0)
				sampleErrorCnt++;
			if (tooBad && onerrorLabel[0]) {
				if (onerrorString[0]) {
					answer = MessageBox(onerrorString,
						"Continue?", MB_YESNOCANCEL);
					if (answer == IDCANCEL)
						return;
					if (answer == IDNO)
						break;
					}
				for (i = 0; i < labelCnt; i++)
					if (! strcmp(onerrorLabel, labels[i].label) &&
						fileNo == labels[i].fileNo)
						break;
				pos = labels[i].pos - 1;
				t = &testProgram[pos];
				}
			break;
		  case BERI2:
		  case BERI3:
			tooBad = 0;
			if (cmd == BERI2) {
			  while (! getWordQuiet(&p, word)) {
				sprintf(word2, "[%s]", word);
				if (! strstr(reply, word2)) {
					msg.Format("%s%s ('%s' expected)",
					errMarker, errorString, word);
					logAdd(msg.GetBuffer(0), 0, 0);
					if (! quiet)	MessageBox(msg);
					tooBad = 1;
					}
				}
			  }
			else {
			  ok = 0;
			  while (! getWordQuiet(&p, word)) {
				if (! strcmp(word, "-"))
					sprintf(word2, "[]", word);
				else
					sprintf(word2, "[%s]", word);
				if (strstr(reply, word2)) {
					ok = 1;
					break;
					}
				}
			  if (! ok) {
				msg.Format("%s%s ('%s' expected)",
				errMarker, errorString, word);
				logAdd(msg.GetBuffer(0), 0, 0);
				if (! quiet)	MessageBox(msg);
				tooBad = 1;
				}
			  }
			if (tooBad && ! statistics)
				pathError[tpStackDepth-1].cnt += 1;
			if (tooBad && currentErrCounter)
				currentErrCounter->val += 1;
			if (tooBad && ! currentErrCounter && sampleNo >= 0)
				sampleErrorCnt++;
			if (tooBad && onerrorLabel[0]) {
				if (onerrorString[0]) {
					sprintf(gotolab, "Go to label %s?", onerrorLabel);
					answer = MessageBox(onerrorString,
						gotolab, MB_YESNOCANCEL);
					if (answer == IDCANCEL)
						return;
					if (answer == IDNO)
						break;
					}
				for (i = 0; i < labelCnt; i++)
					if (! strcmp(onerrorLabel, labels[i].label) &&
						fileNo == labels[i].fileNo)
						break;
				pos = labels[i].pos - 1;
				t = &testProgram[pos];
				}
			break;
		  case DIGITST:
			getWordQuiet(&p, word);
			i = 0;
			makeDigitest(word, &out, 0, &i);
			if (i) {
				msg.Format("%d errors in test '%s'", i,  word);
				logAdd(msg.GetBuffer(0), 0, 0);
				testReportAdd(msg.GetBuffer(0));
				if (! quiet && ! reporting) {
//					MessageBox(msg);
// ----------------------
					SetTimer(TIMER_CLOSE, 5000, timerF);
					SetTimer(TIMER_SET_POS, 10, timerF);
					SetTimer(TIMER_GET_POS, 200, timerF);
					answer = MessageBox(msg, "Info", MB_OKCANCEL | MB_TASKMODAL);
					KillTimer(TIMER_GET_POS);
					if (answer == IDCANCEL)
						return;
// ----------------------
					}
				}
			if (! statistics)
				pathError[tpStackDepth-1].cnt += i;
			if (currentErrCounter)
				currentErrCounter->val += i;
			else
				sampleErrorCnt += i;
			break;
		  case DSET:
			getWordQuiet(&p, word);
			cmd = lookup(word, dataKeys);
			getWordQuiet(&p, word);
			data = word;
			switch (cmd) {
			  case D_TIMEOUT:
				tTTimeout = data;
				m_sTTimeout = data;
				break;
			  case D_NLINES:
				tTNLines = data;
				m_sTNLines = data;
				break;
			  }
			UpdateData(FALSE);	// Set screen values
			break;
		  default:
			if (moduleParser)
				moduleParser(1, *t, 0, 0, reply);
		  }
		cmd0 = cmd;
	  checkEnd:
// if (pos == 21 || pos == 33 || pos == 45)
// sprintf(echo, "##### pos=%d", pos);
// logAdd(echo, 0, 0);
		for (i = tpStackDepth; i > 0; i--) {
			n = pathError[i-1].no;
// sprintf(echo, "\tpos=%d, i=%d, n=%d, tpFiles[n].end=%d", pos, i, n, tpFiles[n].end);
// logAdd(echo, 0, 0);
			if (pos == tpFiles[n].end) {
				word[0] = 0;
				tpStackDepth--;
				if (pathError[tpStackDepth].cnt) {
					sprintf(word, " ***** %d ERRORS",
						pathError[tpStackDepth].cnt);
					}
				sprintf(echo, "End of '%s'%s",
							tpFiles[n].fname, word);
// <-----
	if (sampleNo > 0) {
		for (root[0] = 0, j = 0; j <= tpStackDepth; j++) {
			if (tpFiles[pathError[j].no].id[0]) {
				strcat(root, tpFiles[pathError[j].no].id);
				strcat(root, ".");
				}
			}
		for (j = 0; j < errCounterCnt; j++) {
			if (errCounters[j].fileNo == tpFiles[n].number) {
				strcat(xcelTLine, ", ");
				if (errCounters[j].root)
					strcat(xcelTLine, errCounters[j].root);
				strcat(xcelTLine, errCounters[j].label);
				sprintf(word, "%d", errCounters[j].limit);
				strcat(xcelLLine, ", ");
				strcat(xcelLLine, word);
				sprintf(word, "%d", errCounters[j].val);
				strcat(xcelLine, ", ");
				strcat(xcelLine, word);
				}
			}
		}
// ----->
				logAdd(echo, 0, 0);
//				testReportAdd(echo);
				if (tpStackDepth)
					pathError[tpStackDepth-1].cnt +=
						pathError[tpStackDepth].cnt;
				if (tpStackDepth)
					fileNo = 
						tpFiles[pathError[tpStackDepth-1].no].number;
				}
			}
		}
}


void CTabTest::OnTSend() 
{
	char cmd[CMD_LEN];
	UpdateData(TRUE);	// Get curret values from the screen
	if (! m_sTString.GetLength()) {
		MessageBox("Please, enter String");
		return;
		}
	cmd[0] = 0;
//	strcpy(cmd, "16");		// direct write
	if (addHex(cmd, CMD_LEN, 0, m_sTString, "String"))
		return;
	int close = 0;
	if (! cmd[2] && cmd[0] == '0' &&
		(cmd[1] == 'A' || cmd[1] == 'B' || cmd[1] == 'C' ||
		 cmd[1] == 'a' || cmd[1] == 'b' || cmd[1] == 'c'))
		close = 1;
	if (portWrite(cmd, close, 0))
		return;
	int nn;
	if (! close)
		nn = portRead(cmd, CMD_LEN);
}


void CTabTest::OnTSendRaw() 
{
	char cmd[CMD_LEN];
	UpdateData(TRUE);	// Get curret values from the screen
	if (! m_sTString.GetLength()) {
		MessageBox("Please, enter String");
		return;
		}
	cmd[0] = 0;
//	if (addHex(cmd, CMD_LEN, 0, m_sTString, "String"))
	if (! strlen(m_sTString))
		return;
	strcat(cmd, m_sTString.GetBuffer(0));
	if (portWrite(cmd, 9, 0))
		return;
	int nn;
	nn = portRead(cmd, CMD_LEN);
}


typedef struct {
    char *error;
    char *description;
    int cnt;
    } ErrorList;

static ErrorList errorList[] = {	{"<01>", "unsupported location", 0},
					{"<02>", "memory locked", 0},
					{"<04>", "misc", 0},
					{"<41>", "no NR", 0},
					{"<42>", "no EPC", 0},
					{"<43>", "no RN2", 0},
					{"<44>", "no RN3",  0},
					{"<F", "wrong byte count", 0},
					{"[00;", "successful read", 0}
				};
static int errorCnt;


static void collectErrors(char *str)
{
	static int first = 1;
	int i;
	ErrorList *el;
	if (first) {
		errorCnt = sizeof(errorList) / sizeof(ErrorList);
		for (el = errorList, i = 0; i < errorCnt; i++, el++)
			el->cnt = 0;
		first = 0;
		}
	char *p;
	for (p = str; *p; p++) {
		if (! (p = strchr(p, '<')))	break;
		for (el = errorList, i = 0; i < errorCnt; i++, el++)
			if (! strncmp(p, el->error, strlen(el->error)))
				el->cnt += 1;
		}
}


static void getTPErrors(char *csvErrors, int firstCSV)
{
	*csvErrors = 0;
	char tmp[32];
	int i;
	ErrorList *el;
	if (firstCSV == -1) {
		for (el = errorList, i = 0; i < errorCnt; i++, el++) {
			strcat(csvErrors, el->error);
			strcat(csvErrors, " - ");
			strcat(csvErrors, el->description);
			strcat(csvErrors, "\n");
			}
		return;
		}
	for (el = errorList, i = 0; i < errorCnt; i++, el++) {
		if (i != 0)	strcat(csvErrors, ",");
		if (firstCSV)
			strcat(csvErrors, el->error);
		else {
			sprintf(tmp, "%d", el->cnt);
			strcat(csvErrors, tmp);
			el->cnt = 0;
			}
		}
}


static int portIsOpen = 0;
static HANDLE com;

void portSetReadMode()
{
// return;
#if ! NO_COM
logAdd("portSetReadMode", 0, 0);
	if (! portIsOpen)	return;
	COMMTIMEOUTS commTimeouts;
	int portReady;
	portReady = GetCommTimeouts (com, &commTimeouts);
	commTimeouts.ReadIntervalTimeout = 100;
	commTimeouts.ReadTotalTimeoutConstant = 100;
	commTimeouts.ReadTotalTimeoutMultiplier = 20;
	commTimeouts.WriteTotalTimeoutConstant = 100;
	commTimeouts.WriteTotalTimeoutMultiplier = 20;
	portReady = SetCommTimeouts (com, &commTimeouts);
	portReadMode = 0;
#endif
}

void portSetFastMode()
{
// return;
#if ! NO_COM
logAdd("portSetFastMode", 0, 0);
	if (! portIsOpen)	return;
	COMMTIMEOUTS commTimeouts;
	int portReady;
	portReady = GetCommTimeouts (com, &commTimeouts);
//	commTimeouts.ReadIntervalTimeout = 100;
//	commTimeouts.ReadTotalTimeoutConstant = 100;
//	commTimeouts.ReadTotalTimeoutMultiplier = 20;
	commTimeouts.ReadIntervalTimeout = 0;
	commTimeouts.ReadTotalTimeoutConstant = 6;
	commTimeouts.ReadTotalTimeoutMultiplier = 0;
	commTimeouts.WriteTotalTimeoutConstant = 100;
	commTimeouts.WriteTotalTimeoutMultiplier = 20;
	portReady = SetCommTimeouts (com, &commTimeouts);
	portReadMode = 1;
#endif
}

void portSetScanMode()
{
return;
logAdd("portSetScanMode", 0, 0);
#if ! NO_COM
	if (! portIsOpen)	return;
	COMMTIMEOUTS commTimeouts;
	int portReady;
	portReady = GetCommTimeouts (com, &commTimeouts);
	commTimeouts.ReadIntervalTimeout = 3;
	commTimeouts.ReadTotalTimeoutConstant = 5;
	commTimeouts.ReadTotalTimeoutMultiplier = 1;
	commTimeouts.WriteTotalTimeoutConstant = 100;
	commTimeouts.WriteTotalTimeoutMultiplier = 20;
	portReady = SetCommTimeouts (com, &commTimeouts);
	portReadMode = 2;
#endif
}

void portSetXFastMode()
{
// return;
#if ! NO_COM
	if (! portIsOpen)	return;
	COMMTIMEOUTS commTimeouts;
	int portReady;
	portReady = GetCommTimeouts (com, &commTimeouts);
//	commTimeouts.ReadIntervalTimeout = 100;
//	commTimeouts.ReadTotalTimeoutConstant = 100;
//	commTimeouts.ReadTotalTimeoutMultiplier = 20;
	commTimeouts.ReadIntervalTimeout = 0;
	commTimeouts.ReadTotalTimeoutConstant = 1;
	commTimeouts.ReadTotalTimeoutMultiplier = 0;
	commTimeouts.WriteTotalTimeoutConstant = 100;
	commTimeouts.WriteTotalTimeoutMultiplier = 20;
	portReady = SetCommTimeouts (com, &commTimeouts);
	portReadMode = 3;
#endif
}

void portSetUFastMode(int tot)
{
#if ! NO_COM
	if (! portIsOpen)	return;
	COMMTIMEOUTS commTimeouts;
	int portReady;
	portReady = GetCommTimeouts (com, &commTimeouts);
//	commTimeouts.ReadIntervalTimeout = 100;
//	commTimeouts.ReadTotalTimeoutConstant = 100;
//	commTimeouts.ReadTotalTimeoutMultiplier = 20;
	commTimeouts.ReadIntervalTimeout = 0;
	commTimeouts.ReadTotalTimeoutConstant = tot * 1000;
	commTimeouts.ReadTotalTimeoutMultiplier = 0;
	commTimeouts.WriteTotalTimeoutConstant = 100;
	commTimeouts.WriteTotalTimeoutMultiplier = 20;
	portReady = SetCommTimeouts (com, &commTimeouts);
	portReadMode = 4;
#endif
}


void portSetLogging()
{
	logIO = 1;
}

void portNoLogging()
{
	logIO = 0;
}


BOOL portFindPort(int reconnect)
{
	CString msg;
#if NO_COM
	return;
#endif

	/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
	char			port[20], reply[CMD_LEN];
	int				i;
	BOOL			portReady, flag = 0;
	DCB				dcb;
	COMMTIMEOUTS	commTimeouts;
	/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

	for(i = 12; i >= 0; i--)
	{
		sprintf(port, "COM%d", i);
		logAdd(port, 0, 0);
		sprintf(port, "COM%d", i);
		com = CreateFile
			(
				port,
				GENERIC_READ | GENERIC_WRITE,
				0,		/* exclusive access */
				NULL,	/* no security */
				OPEN_EXISTING,
				0,		/* no overlapped I/O */
				NULL
			);			/* null template */
		if(com == INVALID_HANDLE_VALUE) continue;

		/*
		 * logAdd(" ", 0, 0);
		 */
		portReady = GetCommState(com, &dcb);
#if FAST_COM
//		dcb.BaudRate = 230400;
		dcb.BaudRate = 460800;
		logAdd("FAST_COM", 0, 0);
#else
		dcb.BaudRate = 115200;
#endif
		dcb.ByteSize = 8;
		dcb.Parity = NOPARITY;
		dcb.StopBits = ONESTOPBIT;
		dcb.fAbortOnError = TRUE;
		portReady = SetCommState(com, &dcb);

		commTimeouts.ReadIntervalTimeout = 3;
		commTimeouts.ReadTotalTimeoutConstant = 5;
		commTimeouts.ReadTotalTimeoutMultiplier = 1;
		portReady = SetCommTimeouts(com, &commTimeouts);
		portIsOpen = 1;

		/*
		 * Do a dummy write the first time to allow program ;
		 * execution in the micro to jump to the second loop ;
		 * where it scans for SPI data. A delay of 100ms is ;
		 * given to allow enough time for the micro to complete ;
		 * the first loop.
		 */
/*    	if(portDummyWrite("FF", 0, 0))
		{
			CloseHandle(com);
			continue;
		}

		Sleep(100);  */

		if(portWrite("FF", 0, 0))
		{
			CloseHandle(com);
			continue;
		}


		portRead(reply, CMD_LEN);

		if((strstr(reply, "TRF79")) )//|| *reply)
		{
			sprintf(reply, "COM%d", i);
			topSetComNum(reply);
			CloseHandle(com);
			msg = "**** COM Port found! ****";
			flag = 1;
			if(logIO)
				logAdd(msg, 0, 0);
			else
				logAdd(msg, 1, 0);
			break;
		}

		CloseHandle(com);
	}

	portIsOpen = 0;
	return flag;
}

/////////////////////////////////////////////////
BOOL portFindSinglePort()
{
	/*~~~~~~~~*/
	CString msg;
	/*~~~~~~~~*/

#if NO_COM
	return;
#endif

	/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
	char			reply[CMD_LEN];
	BOOL			portReady, flag = 0;
	DCB				dcb;
	COMMTIMEOUTS	commTimeouts;
	/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

		com = CreateFile
			(
				comPort,
				GENERIC_READ | GENERIC_WRITE,
				0,		/* exclusive access */
				NULL,	/* no security */
			    OPEN_EXISTING,
				NULL,
				0
			);			/* null template */
		if(com == INVALID_HANDLE_VALUE) 
		{
			msg = "**** Error opening COM port! ****";
			if(logIO)
				logAdd(msg, 0, 0);
			else
				logAdd(msg, 1, 0);
		}


		portReady = GetCommState(com, &dcb);
		dcb.BaudRate = 115200;
		dcb.ByteSize = 8;
		dcb.Parity = NOPARITY;
		dcb.StopBits = ONESTOPBIT;
		dcb.fAbortOnError = TRUE;
		portReady = SetCommState(com, &dcb);

		commTimeouts.ReadIntervalTimeout = 100;
		commTimeouts.ReadTotalTimeoutConstant = 500;
		commTimeouts.ReadTotalTimeoutMultiplier = 20;
		portReady = SetCommTimeouts(com, &commTimeouts);
		portIsOpen = 1;

		/*
		 * Do a dummy write the first time to allow program ;
		 * execution in the micro to jump to the second loop ;
		 * where it scans for SPI data. A delay of 100ms is ;
		 * given to allow enough time for the micro to complete ;
		 * the first loop.
		 */
/*	if(portDummyWrite("FF", 0, 0))
		{
			CloseHandle(com);
			msg = "**** Error opening COM port! ****";
			if(logIO)
				logAdd(msg, 0, 0);
			else
				logAdd(msg, 1, 0);
			

		}

		Sleep(100); */

		if(portWrite("FF", 0, 0))
		{
			CloseHandle(com);
			msg = "**** Error opening COM port! ****";
			if(logIO)
				logAdd(msg, 0, 0);
			else
				logAdd(msg, 1, 0);
		
		}

		portRead(reply, CMD_LEN);

		if((strstr(reply, "TRF79")) ) // || *reply)
		{
			msg = "**** COM Port found! ****";
			flag = 1;
			if(logIO)
				logAdd(msg, 0, 0);
			else
				logAdd(msg, 1, 0);

		}
		else
		{
			msg = "**** COM Port NOT found! Check COM Port! ****";			
			if(logIO)
				logAdd(msg, 0, 0);
			else
				logAdd(msg, 1, 0);
		}

		CloseHandle(com);
	

	portIsOpen = 0;
	return flag;
}

static HANDLE portOpen (int mode)
{
	if (! portIsOpen) {
		// Initialize serial port
		if (strlen(comPort.GetBuffer(0)) < 3) {
			hopa("Select serial port");
			return 0;
			}
		logAdd(comPort, 0, 0);
		com = CreateFile(comPort, 
			GENERIC_READ | GENERIC_WRITE,
			0, // exclusive access
			NULL, // no security
			OPEN_ALWAYS,
			0, // no overlapped I/O
			NULL); // null template
		if (com == INVALID_HANDLE_VALUE) {
			CString err = "Failed to open port " + comPort;
			hopa(err);
			return 0;
			}
	
		BOOL portReady;
		DCB dcb;
		portReady = GetCommState(com, &dcb);
#if FAST_COM
//		dcb.BaudRate = 230400;
		dcb.BaudRate = 460800;
#else
		dcb.BaudRate = 115200;
#endif
		dcb.ByteSize = 8;
		dcb.Parity = NOPARITY;
		dcb.StopBits = ONESTOPBIT;
		dcb.fAbortOnError = TRUE;
		portReady = SetCommState(com, &dcb);

		COMMTIMEOUTS commTimeouts;
		portReady = GetCommTimeouts (com, &commTimeouts);
//		commTimeouts.ReadIntervalTimeout = 50;
//		commTimeouts.ReadTotalTimeoutConstant = 50;
//		commTimeouts.ReadTotalTimeoutMultiplier = 10;
//		commTimeouts.WriteTotalTimeoutConstant = 50;
//		commTimeouts.WriteTotalTimeoutMultiplier = 10;
		commTimeouts.ReadIntervalTimeout = 100;
		commTimeouts.ReadTotalTimeoutConstant = 500;
		commTimeouts.ReadTotalTimeoutMultiplier = 20;
		commTimeouts.WriteTotalTimeoutConstant = 100;
		commTimeouts.WriteTotalTimeoutMultiplier = 20;
		if (mode) {
			commTimeouts.ReadIntervalTimeout = 3;
			commTimeouts.ReadTotalTimeoutConstant = 5;
			commTimeouts.ReadTotalTimeoutMultiplier = 1;
			}
		portReady = SetCommTimeouts (com, &commTimeouts);
		portIsOpen = 1;
		}
	return com;
}

void portSpeed (int speed)
{
		BOOL portReady;
		DCB dcb;
		portReady = GetCommState(com, &dcb);
		if (speed == 4)	dcb.BaudRate = 230400;
		else if (speed == 2)	dcb.BaudRate = 460800;
		else			dcb.BaudRate = 115200;
		dcb.ByteSize = 8;
		dcb.Parity = NOPARITY;
		dcb.StopBits = ONESTOPBIT;
		dcb.fAbortOnError = TRUE;
		portReady = SetCommState(com, &dcb);
}


void portReconnect()
{
	CloseHandle(com);
	portFindPort(1);
}


int portWrite (char *data, int close, int binlen)
			// close = 1: close
			//			= 9: no header or trailer
{
	extern int topEnableTRF;
	if (! topEnableTRF && strcmp(data, "03FF")) {
		hopa("Enable TRF7970");
		return 1;
		}
	char sendBuf[CMD_LEN+16], hex[8];
	int len, lenoff;
//memlogAdd("portWrite");
	if (strlen(data) >= CMD_LEN) {
		char msg[CMD_LEN+64];
		data[CMD_LEN] = 0;
		sprintf(msg, "Output buffer overflow at %s", data);
		hopa(msg);
		return 1;
		}
	if (close == 9) {
		strcpy(sendBuf, data);
//memlogAdd("    1");
		}
	else {
		sendBuf[0] = 0;

#if KLICAJI
		strcat(sendBuf, "000");
#endif
		strcat(sendBuf, "0100000304");
		strcat(sendBuf, data);
#if KLICAJI
		strcat(sendBuf, "!!");
#else
		strcat(sendBuf, "0000");
#endif
		len = strlen(sendBuf);
		lenoff = 2;
#if KLICAJI
		len -= 3;
		lenoff += 3;
#endif
		len /= 2;
		len += (binlen + 1) / 2;			// BIN data exch.
		sprintf(hex, "%4.4X", len);
		sendBuf[lenoff] = hex[2];
		sendBuf[lenoff+1] = hex[3];
		sendBuf[lenoff+3] = hex[1];
		}
#if NO_COM
	static ofstream out;
	static int outOpen = 0;
	if (! outOpen) {
		out.open("rfid-reader.out");
		outOpen = 1;
		}
	out << sendBuf << endl;
#endif
//memlogAdd("    3");
	CString msg = "--> ";
	msg = msg + sendBuf;
//memlogAdd("    5");
	if (logIO)
		logAdd(msg, 0, 0);
	else
		logAdd(msg, 1, 0);
#if NO_COM
	return 0;
#endif
//memlogAdd("    6");
	HANDLE com;
	if (! (com = portOpen(0)))
		return 1;
	DWORD nn;
	int i;
//memlogAdd("    8");
	i = WriteFile(com, sendBuf, strlen(sendBuf), &nn, NULL);
//memlogAdd(sendBuf);
//memlogAdd("    9");
	if (i == 0 || nn != strlen(sendBuf))
		msg = "*** Write to port failed ***";
	if (! close || close == 9)
	    return 0;
//memlogAdd("    99");
	CloseHandle(com);
	portIsOpen = 0;
	return 0;
}


int portDummyWrite(char *data, int close, int binlen)
/* close = 1: close ; = 9: no header or trailer */
{
	/*~~~~~~~~~~~~~~~~~~~~~*/
	extern int	topEnableTRF;
	char		sendBuf[1];
	/*~~~~~~~~~~~~~~~~~~~~~*/

	strcpy(sendBuf, data);

	/*~~~~~~~~~~~~~~~~~~~~~~~~*/
#if NO_COM
	static ofstream out;
	static int		outOpen = 0;
	/*~~~~~~~~~~~~~~~~~~~~~~~~*/

	if(!outOpen)
	{
		out.open("rfid-reader.out");
		outOpen = 1;
	}

	out << sendBuf << endl;
#endif

	/*~~~~~~~~~~~~~~~~~*/
	CString msg = "--> ";
	/*~~~~~~~~~~~~~~~~~*/

	msg = msg + sendBuf;

	if(logIO)
		logAdd(msg, 0, 0);
	else
		logAdd(msg, 1, 0);
#if NO_COM
	return 0;
#endif

	/*~~~~~~~~*/
	HANDLE	com;
	/*~~~~~~~~*/

	if(!(com = portOpen(0))) return 1;

	/*~~~~~~~*/
	DWORD	nn;
	int		i;
	/*~~~~~~~*/

	i = WriteFile(com, sendBuf, strlen(sendBuf), &nn, NULL);

	if(i == 0 || nn != strlen(sendBuf)) msg = "*** Write to port failed ***";
	if(!close || close == 9) return 0;

	CloseHandle(com);
	portIsOpen = 0;
	return 0;
}


int portRead (char *data, int len)
{
	portReadCount = len;
	CString msg;
#if NO_COM
	char what[12];
	strncpy(what, data, 10);
	data[10] = 0;
static int count = 0;
//	if (count < 0) {
//		strcpy(data, "--");
//		return 2;
//		}
#define IDENTITY 0
#define x15693_TP	0
#define x15693_TP2	0
#define TAGIT_GET_BLOCK	0
#define TAGIT_GET_BLOCK_SID	0
#define TAGIT_	0
#define TAGIT_VERSION	0
#define FIND	0
#define RG_READ 0
#define x14443A_UID 0
#define x14443A_RATS 0
#define x14443A_PPS 0
#define x14443A_TP	0
#define x14443B 0
#define x14443B_TP	0
#define x176 1
#define x176_TP	0
#define FLC_POLLING 0
#define NFC_ATTRIBUTE 0
#define NFC_TARGET 0
#define NFC_INITIATOR 0
#define DIGIT 1
	int ret = 14;
#if LONG_REPLY
	strcpy(data, "01FF");
	strcat(data, "123456789ee0123456789ee0123456789ee01234567890aa");
	strcat(data, "123456789ee0123456789ee0123456789ee01234567890aa");
#endif
#if HIDDEN_REPLY
	strcpy(data, "pazi prihaja[3C]kr neki");
#endif
#if IDENTITY
	strcpy(data, "pazi prihaja[][0123456789ABCD01,01][,00][][][0123456789ABCD03,45]");
	strcat(data, "[][,67][][0123456789ABCD33,89][][0123456789ABCD09,ab]");
	strcat(data, "[,00][0123456789ABCD11,ef][,00][,23][,00][0123456789ABCD15,FF]");
	strcat(data, "pazi prihaja[][0123456789ABCD01,01][,00][][][0123456789ABCD03,45]");
	strcat(data, "[][,00][][0123456789ABCD33,89][][0123456789ABCD09,ab]");
	strcat(data, "[,00][0123456789ABCD11,ef][,00][,00][,45][0123456789ABCD15,FF]");
#endif
#if IDENTITY_DSFID
	strcpy(data, "pazi prihaja[0123456789ABCD01,AA,BB]kr neki");
#endif
#if x15693_TP
	if (count == 0)
		strcpy(data, "[00][02][00][00][c2][00][00][0e][1f][11][40][00][00][00][00][00][00][00][00][00][00][00][00][00][00][00][0][00][00][00][00]");
	else if (count == 2)
		strcpy(data, "[A565A506000007E0]");
	else if (count == 5)
		strcpy(data, "[55443321]");
	else if (count == 6)
		strcpy(data, "[99887766]");
	else
		strcpy(data, "kr neki [FF]");
#endif
#if x15693_TP2
	if (count == 0) {
		strcpy(data, "[00]");
		}
	else if (count == 1)	{
		strcpy(data, "[00]");
		}
	else if (count == 2)	{
		strcpy(data, "[00]");
		}
	else if (count == 3)	{
		strcpy(data, "[][][][][][A565A506000007E0][][][][][][][][][][]");
		}
	else if (count == 4)	{
		strcpy(data, "[00]");
		}
	else if (count == 5)	{
		strcpy(data, "[][][][][][50061F643120381933002185][][][][][][][][][][]");
		}
#endif
#if TAGIT_GET_BLOCK
	strcpy(data, "v redu[x00][0200112233445566]");
#endif
#if TAGIT_GET_BLOCK_SID
	strcpy(data, "v redu[AABBCCDD020011223344]");
#endif
#if TAGIT_VERSION
	strcpy(data, "v redu[C030009A4C8202020307]");
#endif
#if TAGIT_SID_POLL
	strcpy(data, "v redu[FFEEDDCC02050307][][][3344556607050307][][][6677889902050103][][][][][][][][]");
#endif
#if TAGIT_TP
	if (count == 0)
		strcpy(data, "v redu[FFEEDDCC02050307][][][3344556607050307][][][][][][][][][][][]");
	else if (count == 4)
		strcpy(data, "[01223344]");
	else if (count == 5)
		strcpy(data, "[55667788]");
	else
		sprintf(data, "kr neki [FF%d]", count);
#endif
#if FIND
	static int pass = 0;
	if (! strcmp(what, "_15693_")) {
	  if (pass == 0) {
		strcpy(data, "pazi prihaja 15963[CCCCCCCCCCCCCCCC,00][0123456789ABCD01,11][][0123456789ABCD03,33]");
		strcat(data, "[][][][0123456789ABCD33,66][][0123456789ABCD09,99]");
		strcat(data, "[][0123456789ABCD11,BB][][][][0123456789ABCD15,FF]");
	   }
	  else {
		strcpy(data, "pazi prihaja 15963[CCCCCCCCCCCCCCCC,00][0123456789ABCD01,11][][]");
		strcat(data, "[][][][0123456789ABCD33,66][][0123456789ABCD09,99]");
		strcat(data, "[][0123456789ABCD11,BB][][][][0123456789ABCD15,FF]");
	   }
		}
	else if (! strcmp(what, "_14443A_")) {
	  if (pass == 0)
		strcpy(data, "mamo 14443A [001122AA33445566BB]<garbage>[CCCCCCCCCCCCCCCCCCCCCCCCCC]se neki[33221100AA]");
	  else
		strcpy(data, "mamo 14443A [001122AA33445566BB]<garbage>[CCCCCCCCCCCCCCCCCCCCCCCCCC]se neki[33221100AA][0123456789ABCDEF0123456789]");
		}
	else if (! strcmp(what, "_14443B_")) {
	  if (pass == 0)
		strcpy(data, "gre 14443B [5042C862E100000000002185][00][5000024E3800000000000041]");
	  else
		strcpy(data, "gre 14443B [5042C862E100000000002185][00][5000024E3800000000000041]");
		}
	else if (! strcmp(what, "_Tagit_")) {
	  if (pass == 0)
		strcpy(data, "v redu TAGIT[FFEEDDCC02050307][][][3344556607050307][][][6677889902050103][FFEECCCCCCCC0307][][][][][][][]");
	  else
		strcpy(data, "v redu TAGIT[FFEEDDCC02050307][][][][][][6677889902050103][FFEECCCCCCCC0307][][][][][][][]");
		}
	else if (! strcmp(what, "_FeliCa_")) {
	  if (pass == 0)
		strcpy(data, "se FeliCa [CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC][0123456789ABCDEF0123456789ABCDEF0123]");
	  else
		strcpy(data, "se FeliCa [CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC][0123456789ABCDEF0123456789ABCDEF0123][abcdefabcdefabcdefabcdefabcdefabcdef]");
		}
	else if (! strcmp(what, "_EPC_")) {
	  if (pass == 0)
		strcpy(data, "in EPC [CCCCCCCCCCCCCCCCCCCCCCCC][00][5000024E3800000000000041]");
	  else
		strcpy(data, "in EPC [CCCCCCCCCCCCCCCCCCCCCCCC][00][5000024E3800000000000041]");
		pass = (pass) ? 0 : 1;
		}
#endif
#if RG_READ
//	strcpy(data, "pazi prihaja[00][01][02][03][04][05][06][07][08][09]");
//	strcat(data, "[10][11][12][13][14][15][16][17][18][19]");
//	strcat(data, "[20][21][22][23][24][25][26][27][28][29][30]");
	strcpy(data, "[1][2][0][0][c2][0][0][e][1f][11][40][87][0][3e][0][0]");
	strcat(data, "[0][0][0][0][0][0][0][0][0][0][0][0][0][0][0]");
#endif
#if x14443A_UID
	strcpy(data, "smeti[001122AA33445566BB]<garbage>[001122AA334455BB66778899CC]se neki[33221100AA]");
#endif
#if x14443A_RATS
	strcpy(data, "smeti[001122AA33445566BB]<garbage>[001122AA334455BB66778899CC]se neki[33221100AA]");
	if (count == 5)
		strcpy(data, "smeti[020F] no TA,TB,TC,history");
	else if (count == 6)
		strcpy(data, "smeti [025F7203AABB] TA,TC,history");
	else if (count == 7) {
		strcpy(data, "smeti [02107203AABB] TB,history");
		count = -1;
		}
#endif
#if x14443A_PPS
	strcpy(data, "smeti[5042C862E10000]<garbage>[000024E380000000009]se neki[5042C862]");
#endif
#if x14443A_TP
	if (count == 0) {
		strcpy(data, "[00]");
		}
	else if (count == 1)	{
		strcpy(data, "[00]");
		}
	else if (count == 2)	{
		strcpy(data, "[00]");
		}
	else if (count == 3)	{
		strcpy(data, "[][][][][][50061F643120381933002185][][][][][][][][][][]");
		}
	else if (count == 4)	{
		strcpy(data, "[00]");
		}
	else if (count == 5)	{
		strcpy(data, "[][][][][][50061F643120381933002185][][][][][][][][][][]");
		}
#endif
#if x14443B
	strcpy(data, "[5042C862E100000000002185][5000024E3800000000000041][5042C862E099000099992703]");
#endif
#if x14443B_TP
	if (count == 0) {
		strcpy(data, "[00]");
		}
	else if (count == 1)	{
		strcpy(data, "[00]");
		}
	else if (count == 2)	{
		strcpy(data, "[00]");
		}
	else if (count == 3)	{
		strcpy(data, "[][][][][][50061F643120381933002185][][][][][][][][][][]");
		}
	else if (count == 4)	{
		strcpy(data, "[00]");
		}
	else if (count == 5)	{
		strcpy(data, "[][][][][][50061F643120381933002185][][][][][][][][][][]");
		}
#endif
#if x176
	int n = 3;
	if (count == n+0) {
		strcpy(data, "[AA]");
		}
	else if (count == n+1) {
		strcpy(data, "[AA]");
		}
	else if (count == n+2) {
		strcpy(data, "[0123]");
		}
	else if (count == n+3) {
		strcpy(data, "[4567]");
		}
	else if (count == n+4) {
		strcpy(data, "[89AB]");
		}
	else if (count == n+5) {
		strcpy(data, "[CDEF]");
		}
	else if (count == n+6) {
		strcpy(data, "[9ABC]");
		}
	else if (count == n+9) {
		strcpy(data, "[AA78]");
		}
	else {
		strcpy(data, "[]");
		}
#endif
#if x176_TP
	if (count == 0) {
		strcpy(data, "[00]");
		}
	else if (count == 1)	{
		strcpy(data, "[00]");
		}
	else if (count == 2)	{
		strcpy(data, "[00]");
		}
	else if (count == 3)	{
		strcpy(data, "[][][][][][50061F643120381933002185][][][][][][][][][][]");
		}
	else if (count == 4)	{
		strcpy(data, "[00]");
		}
	else if (count == 5)	{
		strcpy(data, "[][][][][][50061F643120381933002185][][][][][][][][][][]");
		}
#endif
#if FLC_POLLING
	strcpy(data, "se FeliCa gre [112233445566778811223344556677881122] in [0123456789ABCDEF0123456789ABCDEF0123]");
#endif
#if NFC_ATTRIBUTE
	strcpy(data, "[vstavi neki]");
#endif
#if NFC_TARGET
	if (count == 2)
		strcpy(data, "Porka flek");
	else if (count == 3)
		strcpy(data, "To ni res");
	else if (count == 4)
		strcpy(data, "<<FILE>>zzz.z3");
	else if (count == 5)
		strcpy(data, "8B");
	else if (count == 6)
		strcpy(data, "prva vrsta\n");
	else if (count == 7)
		strcpy(data, "8C");
	else if (count == 8)
		strcpy(data, "druga vrsta\n");
	else if (count == 9)
		strcpy(data, "0D");
	else if (count == 10)
		strcpy(data, "tretja vrsta\n");
	ret = strlen(data);
#endif
#if NFC_INITIATOR
	strcpy(data, "[00]");
	ret = strlen(data);
#endif
#if DIGIT
	if (! (count % 10))
//		strcpy(data, "AA");
		data[1] = 'A';
	ret = strlen(data);
#endif
	count++;
	msg = "<-- ";
	msg = msg + data;
	if (logIO)
		logAdd(msg, 0, 0);
	else
		logAdd(msg, 1, 0);
	collectErrors(data);
	return ret;
#endif
	HANDLE com;
	if (! (com = portOpen(0))) {
		*data = 0;
		return 0;
		}
	DWORD nn;
	int i;
	i = ReadFile(com, data, len, &nn, NULL);
	/*
	if (i == 0) {
		int err = GetLastError();
		LPVOID lpMsgBuf;
		if (! FormatMessage(
				FORMAT_MESSAGE_ALLOCATE_BUFFER |
				FORMAT_MESSAGE_FROM_SYSTEM | 
				FORMAT_MESSAGE_IGNORE_INSERTS,
				NULL,
				GetLastError(),
				MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
				(LPTSTR) &lpMsgBuf,
				0,
				NULL ))
			err = 0;
		char errmsg[256];
		sprintf(errmsg, "%s", lpMsgBuf);
		LocalFree( lpMsgBuf );
		portIsOpen = 0;
		CloseHandle(com);
		portRead(data, len);
		}
		*/
	if (i == 0)	nn = 0;
	if (nn == 0) {
		*data = 0;
		msg = "*** Read TIMEOUT ***";
		}
	else {
		if ((int) nn > len)	nn = len;
		data[nn] = 0;
		msg = "<-- ";
		msg = msg + data;
		}
	if (logIO)
		logAdd(msg, 0, 0);
	else
		logAdd(msg, 1, 0);
	// remove unexpected characters
	collectErrors(data);
	return nn;
}


int portScan (char *data, int len)
{
#if NO_COM
	static int count = 0;
	data[0] = 0;
	if (count == 5)
		strcpy(data, "0A");
	else if (count == 100)
		strcpy(data, "09");
	else if (count == 200)
		strcpy(data, "8E");
	count++;
	return strlen(data);
#endif
	CString msg;
	HANDLE com;
	if (! (com = portOpen(1))) {
		*data = 0;
		return -1;
		}
	DWORD nn;
	int i;
	i = ReadFile(com, data, len, &nn, NULL);
	if (i == 0)	nn = 0;
	if (nn == 0) {
		*data = 0;
//		msg = "*** Scan TIMEOUT ***";
		}
	else {
		if ((int) nn > len)	nn = len;
		data[nn] = 0;
		msg = "<.- ";
		msg = msg + data;
		if (logIO)
			logAdd(msg, 0, 0);
		else
			logAdd(msg, 1, 0);
		}
	return nn;
}


void CTabTest::OnTExpert()
{
	UpdateData(TRUE);	// Get curret values from the screen
	expert = m_bTExpert;
}


void CTabTest::OnTEcho() 
{
	UpdateData(TRUE);	// Get curret values from the screen
	if (m_bTEcho)	portWrite("F1", 0, 0);
	else		portWrite("F0", 0, 0);
	char reply[CMD_LEN];
	portRead(reply, CMD_LEN);
}


int cmpMask(char *ref, char *reply, char *patternMask, char *outPattern,
								int size)
{
	char refB[128], replyB[128], maskB[128], *p, *r, *o, *m;
	int good = 1, i;
	strcpy(refB, hex2bin(ref));
	strcpy(replyB, hex2bin(reply));
	strcpy(maskB, hex2bin(patternMask));
	refB[size] = 0;
	for (i = 0, m = maskB, o = outPattern, r = replyB, p = refB; *p;
						p++, r++, o += 2, m++, i++) {
		if (*p != *r) {
			*o = '1';
			if (*m != '1') {
				good = 0;
				*(o+1) = '1';
				}
			}
		}
	if (good)
		return 0;
	return 1;
}


int cmpTol(char *ref, char *reply, char *outPattern,
		char **currentPattern, int patternNo, int patternCnt,
		int tolerances, int *tol, int size)
{
	char refB[128], replyB[128], refBx[128], *p, *r, *o, **cp;
	int beg, end, badBit, good = 1, i, j;
	strcpy(refB, hex2bin(ref));
	strcpy(replyB, hex2bin(reply));
	refB[size] = 0;
	for (i = 0, o = outPattern, r = replyB, p = refB; *p;
						p++, r++, o += 2, i++) {
		if (*p != *r) {
			*o = '1';
			if (! tolerances) {
				good = 0;
				*(o+1) = '1';
				continue;
				}
			beg = patternNo - tol[2*i];
			if (beg < 0)	beg = 0;
			else			beg = - tol[2*i];
			end = patternNo + tol[2*i+1] - patternCnt;
			if (end < 0)	end = tol[2*i+1];
			for (badBit = 1, j = beg; j <= end; j++) {
				cp = currentPattern + j;
				strcpy(refBx, hex2bin(*cp));
				if (refBx[i] == *r) {
					badBit = 0;
					break;
					}
				}
			if (badBit) {
				good = 0;
				*(o+1) = '1';
				}
			}
		}
	if (good)
		return 0;
	return 1;
}


#define TOL_INIT	-98765
int decodeTolerances(char *p, int *tol, int size, char **signals, int lineno)
{
	// Tolerance syntax example 2 OUT X3 3:4 data 1
	//  OUT, X3 may change	2 clocks before and 2 clocks after reference
	// data may change	3 clocks before and 4 clocks after reference
	// all other signals may change
	//			1 clocks before and 1 clocks after reference
	char msg[1024], signal[64], *d, **s;
	int before, after, i;
	for (i = 0; i < size; i++)
		tol[2*i] = tol[2*i+1] = TOL_INIT;
	while (isspace(*p))	p++;
	while (*p) {
		if (! isdigit(*p)) {
			sprintf(msg, "Digit expected at '%s'", p);
			hopa(msg);
			return 1;
			}
		before = atoi(p);
		while (isdigit(*p))	p++;
		after = before;
		if (*p == ':') {
			p++;
			if (! isdigit(*p)) {
				sprintf(msg, "Digit expected at '%s'", p);
				hopa(msg);
				return 1;
				}
			after = atoi(p);
			while (isdigit(*p))	p++;
			}
		else if (*p && ! isspace(*p)) {
			sprintf(msg, "Space expected at '%s'", p);
			hopa(msg);
			return 1;
			}
		while (isspace(*p))	p++;
		if (isdigit(*p)) {
			sprintf(msg, "Signal name expected at '%s'", p);
			hopa(msg);
			return 1;
			}
		if (! *p) {
			// set all initilized tolerances
			for (i = 0; i < size; i++) {
				if (tol[2*i]   == TOL_INIT)	tol[2*i]   = before;
				if (tol[2*i+1] == TOL_INIT)	tol[2*i+1] = after;
				}
			}
		while (*p && ! isdigit(*p)) {
			for (d = signal; *p && *p != ' '; )	*d++ = *p++;
			*d = 0;
			for (s = signals, i = 0; i < size; i++, s++)
				if (! strcmp(signal, *s))	break;
			if (i >= size) {
				sprintf(msg, "Unexpected tolerance signal '%s'", signal);
				hopa(msg);
				return 1;
				}
			tol[2*i]   = before;
			tol[2*i+1] = after;
			while (isspace(*p))	p++;
			}
		}
	// set all initilized tolerances
	for (i = 0; i < size; i++) {
		if (tol[2*i]   == TOL_INIT)	tol[2*i]   = 0;
		if (tol[2*i+1] == TOL_INIT)	tol[2*i+1] = 0;
		}
	return 0;
}


void file2pcb (char *file, char *pcb, int *xrf)
{
	char fileB[MAX_LINE], pcbB[MAX_LINE];
	int *x, i, l;
// char msg[20];
	strcpy(fileB, hex2bin(file));
// logAdd(fileB, 0, 0);
	for (i = 0, x = xrf; *x != LAST_XRF; x++, i++) {
// sprintf(msg, "%d::%d, %d", i, *x, *(x+1));
// logAdd(msg, 0, 0);
		if (*x == EMPTY_XRF)	pcbB[i] = '0';
		else			pcbB[i] = fileB[*x];
		}
	pcbB[i] = 0;
	l = i / 4;
	if (i % 4)	l++;
// logAdd(pcbB, 0, 0);
	strcpy(pcb, (bin2hex(pcbB, l)));
}
	

void pcb2file (char *pcb, char *file, int *xrf, int cnt)
{
	char fileB[MAX_LINE], pcbB[MAX_LINE];
	int *x, i, l;
	strcpy(fileB, hex2bin(file));
	strcpy(pcbB, hex2bin(pcb));
	for (i = 0, x = xrf; *x != LAST_XRF; x++, i++) {
		if (*x != EMPTY_XRF)
			fileB[*x] = pcbB[i];
		}
	fileB[cnt] = 0;
	l = cnt / 4;
	if (cnt % 4)	l++;
	strcpy(file, (bin2hex(fileB, l)));
}
	

int makeDigitest(char *fname, ofstream *out, int open, int *errcnt)
{
	// Open current test program file
	int status = 0, errors = 0, wasOpen = open, len = CMD_LEN, pack = 0,
		sigCnt = 0, tolerances = 0, haveTimestep = 0, outCnt = 0,
		debug = 0;
	double timestep = 1, tt;
#if DIGI_PACK
	pack = 1;
#endif
ofstream zz;
	ifstream tpat;
	tpat.open(fname);
	ofstream sig;
	char msg[MAX_LINE];
	if (tpat.fail()) {
		sprintf(msg, "Can not open %s", fname);
		logAdd(msg, 0, 0);
		errors++;
		goto done;
		}
	char line[MAX_LINE], reply[CMD_LEN], mask[CMD_LEN], title[MAX_LINE],
		packet[MAX_LINE*MAX_LINES], lines[MAX_LINES][MAX_LINE],
		pp[MAX_LINE], rr[MAX_LINE], rr2[MAX_LINE],
		outPattern[MAX_PATTERN],
		patternMask[MAX_LINE], IOMask[MAX_LINE], iob[MAX_LINE],
		pline[2048], pline2[2048], pval[4], cc,
		*sigNames[MAX_PATTERN],
		*start, *p, *r, *pm, *dr, *t,
		**patterns,
#if SIGT_AT_END
		**patternsOut, *patternErr, *patternDiff,
		**patternsMask, **patIOMask, **p2o, *pe, *pd, *pio,
		**p2m, **p2io,
#else
		linex[MAX_LINE], replyx[CMD_LEN],
#endif
		**p2;
	int tol[MAX_PATTERN][2], outputs[MAX_PATTERN], xrf[MAX_PATTERN],
		lineno, body, packetLen, dataLen, single, dataCnt, dataTotLen,
		patternSize, patternCnt, patternNo, tooBad, xrferr, bcnt,
		maskCnt, sampleCnt, appendix, diffVal, i, j, k, n;
	unsigned memsize;
	typedef struct {
		int	offset;
		char	maskS[MAX_LINE];
		} MMask;
	MMask masks[64];

	digiTimeout = atoi(tTTimeout.GetBuffer(0));
	digiPackLen = atoi(tTNLines.GetBuffer(0));

	patternSize = 8192;
	memsize = patternSize * sizeof(char *);
        if ((patterns = (char **) malloc(memsize)) == (char **) NULL) {
		hopa("Out of memory (pat0)");
		exit(1);
		}

	for (i = 0; i < MAX_PATTERN; i++)
		outputs[i] = 0;
	// Load the entire pattern
	if (! wasOpen) {
		strcpy(line, fname);
		strcat(line, ".out");
		out->open(line);
		open = 1;
		}
	patternCnt = 0;
	p2 = patterns;
	lineno = 0;
	while (tpat.eof() == 0) {
		tpat.getline(line, MAX_LINE, '\n');
		lineno++;
		p = line;
		if (*p == '.') {
			if ((r = strchr(line, '#')))
				*r = 0;	// inline comment
			// save  outputs
			strcpy(reply, hex2bin(p+1));
			for (i = 0, r = reply; *r; r++, i++)
				if (*r == '0')	outputs[i] = 1;
			}
		if (*p == ',')
			continue;
		// skip comments, IO mask, checking windows
		if (! (*p >= '0' && *p <= '9') && ! (*p >= 'A' && *p <= 'F'))
			continue;
		start = p;
		if ((p = strchr(start, '#')))	*p = 0;	// inline comment
		p = start;
		p += strlen(p) - 1;		// remove trailing spaces
		while (isspace(*p))	p--;
		p++;
		*p = 0;
		p = start;
		if (!patternCnt || patternCnt >= patternSize) {
			char **tmppat = patterns, **t2;
			// get 4 times what was not sufficient
			patternSize *= 4;
			memsize = patternSize * sizeof(char *);
			if ((patterns = (char **) malloc(memsize)) ==
                                                        (char **) NULL) {
				hopa("Out of memory (pat0)");
				exit(1);
				}
			for (p2 = patterns, t2 = tmppat, i = 0;
							i < patternCnt; i++)
			    *p2++ = *t2++;
			if (patternCnt) {
				free(tmppat);
				}
			}
		*p2++ = strdup(start);
		patternCnt++;
		}
	tpat.close();
	tpat.clear();
	tpat.open(fname);

#if SIGT_AT_END
	// get memory for output patterns
	memsize = patternCnt * sizeof(char *);
	if ((patternsOut = (char **) malloc(memsize)) == (char **) NULL) {
		hopa("Out of memory (pat1)");
		exit(1);
		}
	if ((patternDiff = (char *) malloc(patternCnt+1)) == (char *) NULL) {
		hopa("Out of memory (pat2)");
		exit(1);
		}
	if ((patternErr = (char *) malloc(patternCnt+1)) == (char *) NULL) {
		hopa("Out of memory (pat3)");
		exit(1);
		}
	if ((patternsMask = (char **) malloc(memsize)) == (char **) NULL) {
		hopa("Out of memory (pat1)");
		exit(1);
		}
	if ((patIOMask = (char **) malloc(memsize)) == (char **) NULL) {
		hopa("Out of memory (pat1)");
		exit(1);
		}
#endif

/*
for (p2 = patterns, i = 0; i < patternCnt; i++, p2++) {
zzx[i] = *(p2-1);
}
strcpy(line, fname);
strcat(line, ".zz");
zz.open(line);
for (p2 = patterns, i = 0; i < patternCnt; i++, p2++) {
zz << i << ": " << *p2 << endl;
//sprintf(msg, "%d: %s", i, *p2);
//logAdd(msg, 0, 0);
zz.flush();
}
zz.close();
 */

	// check all patterns
//	*errcnt = 0;
	packet[0] = 0;
	title[0] = 0;
	packetLen = dataCnt = maskCnt = 0;
	p2 = patterns;
#if SIGT_AT_END
	p2o = patternsOut;
	pd = patternDiff;
	pe = patternErr;
	p2m = patternsMask;
	p2io = patIOMask;
	strcpy(patternMask, "00000000000000000000000000000000");
	if (patternCnt)
		patternMask[strlen(*p2) - 1] = 0;
	strcpy(IOMask, "00000000000000000000000000000000");
	if (patternCnt)
		IOMask[strlen(*p2) - 1] = 0;
#endif
	sampleCnt = 0;
	patternNo = 0;
	for (i = 0; i < MAX_PATTERN; i++)
		xrf[i] = EMPTY_XRF;
	appendix = lineno = 0, body = 0;
	while (tpat.eof() == 0) {
		if (digiCancel)	break;
		tpat.getline(line, MAX_LINE, '\n');
		lineno++;
		p = line;
// logAdd(line, 0, 0);
		while (isspace(*p))	p++;
		if (*p == '#') {
			if (*(p+1) == '>' && *(p+2) == '>') {
				p += 3;
				while (isspace(*p))	p++;
				if (! strncmp(p, "Debug:", 6)) {
					p += 6;
					while (isspace(*p))	p++;
					debug = atoi(p);
					}
				else if (! strncmp(p, "Timestep:", 9)) {
					if (patternNo) {
						hopa("Timestep must preceed patterns.");
						return 1;
						}
					p += 9;
					while (isspace(*p))	p++;
					if (haveTimestep) {
						hopa("Invalid timestep redefinition.");
						return 1;
						}
					timestep = atof(p);
					timestep *= 1e-9;
					haveTimestep = 1;
					}
				else if (! strncmp(p, "Title:", 6)) {
					p += 6;
					while (isspace(*p))	p++;
					strcpy(title, p);
					}
				else if (! strncmp(p, "Tolerances:", 11)) {
					p += 11;
					hopa("To ne gre z XRF.");
					if (! sigCnt) {
						hopa("Signal names not yet defined.\nPlace Tolerances line after the signal names line.");
						return 1;
						}
					while (isspace(*p))	p++;
					if (decodeTolerances(p, (int *) tol, sigCnt,
							sigNames, lineno)) {
						hopa("Bad tolerances syntax.");
						return 1;
						}
					tolerances = 1;
					}
				else {
					sprintf(msg, "Invalid #>> keyword at '%s'.", p);
					hopa(msg);
					return 1;
					}
				}
			*out << line << endl;
			continue;	// comment line
			}
		start = p;
		if ((p = strchr(start, '#')))	*p = 0;	// inline comment
		p = start;
		p += strlen(p) - 1;		// remove trailing spaces
		while (isspace(*p))	p--;
		p++;
		*p = 0;
		if (! strlen(start))	continue;	// empty line
		p = line;
		if (*p == ',') {
			if (pack) {
//				masks[maskCnt].offset = packetLen - 1;
				masks[maskCnt].offset = packetLen;
				strcpy(masks[maskCnt++].maskS, p+1);
				}
			else
				strcpy(patternMask, p+1);
			}
		if (*p == ':' || body)	body++;
		if (! strncmp(p, ">include", 8)) {
			if (body) {
				*out << "\t'" << fname <<
					"' Invalid include inside body." <<endl;
				errors++;
				goto done;
				}
			while (! isspace(*p))	p++;
			while (isspace(*p))	p++;
			if (! *p) {
				*out << "\t'" << fname <<
					"' Invalid missing file name." << endl;
				errors++;
				goto done;
				}
			*out << "<<<<<<<<<<<<< " << p << endl;
			if (makeDigitest(p, out, open, errcnt))
				goto done;
			continue;
			}
		if (body == 1 && *p != ':') {
			*out << "\t'" << fname <<
				"' Body must start with a ':' line." << endl;
			errors++;
			goto done;
			}
		if (body == 2 && *p != '.') {
			*out << "\t'" << fname <<
				"' Must define pin types ('.') ':' in second line." << endl;
			errors++;
			goto done;
			}
		single = 0;
		if (*p == ':') {
/* 12-JUL-2007 *
			portWrite("CC", 0, 0);
			portRead(reply, CMD_LEN);
			portNoLogging();
			portSetUFastMode(1);
			len = CMD_LEN;
//			len = 1;
			single = 1;
			p0 = p;
			p++;
			while (*p) {
				for (r = reply; *p && *p != ','; ) {
					if (*p == ';')
						p++;
					else
						*r++ = *p++;
					}
				*r = 0;
				sigNames[sigCnt++] = strdup(reply);
				if (*p)	p++;
				}
			p = p0;
 * 12-JUL-2007 */
			// build signal table
			p++;
			while (*p && *p != ';') {
				for (r = rr; *p && *p != ',' && *p != ';'; )
					*r++ = *p++;
				*r = 0;
				sigNames[sigCnt++] = strdup(rr);
				if (*p)	p++;
				}
			// get PCB bit order
			do {
			    portWrite("CC", 0, 0);
			    reply[0] = 0;
			    portRead(reply, CMD_LEN);
				} while (strstr(reply, "test ready:"));
			portNoLogging();
			logAddFileOnly();
//			logAddNoFile();
//			portSetUFastMode(digiTimeout);
			portSetUFastMode(1);
			if (! reply[0])	return 1;	// timeout
			len = CMD_LEN;
//			len = 1;
			single = 1;
			// build the file/PCB cross reference
			xrferr = 0;
			for (p = reply; *p && *p != ':'; p++)	/* Nothing */;
			if (*p)	p++;
			for (i = 0; *p && *p != ';'; p++, i++) {
				if (i >= MAX_PATTERN) {
					hopa("Too many signals requested by PCB");
					return 1;
					}
				for (r = rr; *p && *p != ',' && *p != ';'; )
					*r++ = *p++;
				*r = 0;
				if (! strlen(rr)) {
					xrf[i] = EMPTY_XRF;
					continue;
					}
				xrf[i] = LAST_XRF;
				for (j = 0; j < sigCnt; j++) {
					if (! strcmp(sigNames[j], rr)) {
						xrf[i] = j;
// sprintf(msg, "%d <-- %d", i, j);
// logAdd(msg, 0, 0);
						break;
						}
					}
				if (xrf[i] == LAST_XRF) {
					sprintf(msg,
					"Signal '%s' requested by PCB is not avalable in file '%s'", rr, fname);
					hopa(msg);
					xrferr++;
					}
				if (*p == ';')	break;
				}
			i++;
// sprintf(msg, "%d <== %d", i, LAST_XRF);
// logAdd(msg, 0, 0);
			xrf[i] = LAST_XRF;
			if (xrferr) {
				hopa("Aborting");
				return 1;
				}
			continue;
/* 12-JUL-2007 */
			}
		else if (*p == '.') {
			if (! pack)	strcpy(IOMask, p+1);
/* 12-JUL-2007 */
			file2pcb(p+1, rr, xrf);
			strcpy(pp, ".");
			strcat(pp, rr);
			p = pp;
/* 12-JUL-2007 */
			len = strlen(p);
			}
		else if (*p == ',') {
			*out << p << endl;
			continue;
			}
		else if (*p == '$') {
			len = CMD_LEN;
			single = 1;
			body = 0;
			continue;
			}
		else {
/* 12-JUL-2007 */
// logAdd(p, 0, 0);
			file2pcb(p, pp, xrf);
// logAdd(" --> ", 0, 0);
// logAdd(pp, 0, 0);
			p = pp;
			dataCnt++;
/* 12-JUL-2007 */
			dataLen = strlen(p);
			len = strlen(p);
			}
		if (pack) {
			strcpy(lines[packetLen], line);
//			if (packet[0])	strcat(packet, ",");
			if (*p != '.')	strcat(packet, ":");
			strcat(packet, p);
			packetLen++;
			if (packetLen >= digiPackLen || single) {
  last:
				strcat(packet, ";");
				portWrite(packet, 9, 0);
//				dataTotLen = (dataCnt + 1) * dataLen;
				dataTotLen = strlen(packet);
				portRead(reply, dataTotLen);
//				portRead(reply, 100);		/* debug */
				}
			else
				continue;
			}
		if (! pack || single) {
			strcpy(lines[0], line);
			portWrite(p, 9, 0);
#if NO_COM
			strcpy(reply, p);
#endif
			portRead(reply, len);
			// everything is OK
			if (*p == '.')
				continue;
			strcpy(packet, p);
			packetLen = 1;
			}
		for (r = reply; *r && *r != ';' && *r != '.' && *r != ':'; r++)
			/* Nothing */;
		for (r = reply, bcnt = 0; *r && *r != ';' && bcnt < packetLen; bcnt++) {
			p = lines[bcnt];
			if (*p == '.')	strcpy(IOMask, p+1);
// if (patternNo > 2030)
// i++;
			for (i = 0; i < maskCnt; i++) {
				if (bcnt == masks[i].offset)
					strcpy(patternMask, masks[i].maskS);
				}
			for (i = 0; i < MAX_O_PATTERN-1; i++)
				outPattern[i] = '0';
			outPattern[2*sigCnt] = 0;
			*out << p;
			if (*p == '.' && timestep)
				*out << "  (" << patternNo * timestep <<
									 ')';
			if (*p == '.') {
				r++;
				while (*r &&
					! (*r == ',' || *r == '.' || *r == ':'))
					r++;
				if (*r == ',' || *r == '.' || *r == ':') r++;
				*out << '\n';
				continue;
				}
			*pd = '0';
			*pe = '0';
			if (*r == ':')	r++;
			dr = rr2;
			for (j = 0; j < dataLen; j++) {
				*dr++ = *r++;
				}
			*dr = 0;
			if (*r == ',' || *r == '.' || *r == ':')	r++;
			strcpy(rr, p);
// logAdd(rr2, 0, 0);
			pcb2file(rr2, rr, xrf, sigCnt);
// logAdd(" ==> ", 0, 0);
// logAdd(rr, 0, 0);
			if (strcmp(p, rr)) {
				sampleCnt++;
				*pd = '1';
#if 0
				if (p != *p2)
					*out << "???" << " " << *p2;
#endif
				*out << " ??? " << rr;
// if (patternNo > 11052)
// j = 0;
				tooBad = cmpMask(p, rr, patternMask,
						outPattern, sigCnt);
				if (tolerances && tooBad)
				  tooBad = cmpTol(p, rr, outPattern,
							p2, patternNo,
							patternCnt,
							tolerances, (int *) tol,
							sigCnt);
				if (tooBad) {
					*pe = '1';
					t = (title[0]) ? title : fname;
					*out << " " << "\t(line=" <<
						lineno-packetLen+bcnt+1 <<
						" #" << sampleCnt;
					if (timestep) {
						tt = patternNo * timestep;
						*out << " @ " << tt;
						}
					*out << ") *** Error" <<
" " << outPattern;
					errors++;
					}
				else if (! (sampleCnt % SMP_WRITE))
					*out << "\t#sample=" << sampleCnt;
				}
			*out << endl;
			p2++;
#if SIGT_AT_END
			*p2o++ = strdup(outPattern);
			outCnt++;
// sprintf(msg, "%d: '%s', %d] '%s', %d", lineno, reply, bcnt, rr, outCnt);
// logAdd(msg, 0, 0);
			pd++;
			pe++;
			*p2m++ = strdup(patternMask);
			*p2io++ = strdup(IOMask);
#else
			strcpy(linex, hex2bin(*p2));
			strcpy(replyx, *p2o);
			strcpy(mask, hex2bin(*p2m));
// if (i > 9520)
// j = 0;
			pline[0] = 0;
			for (j = 0, p = linex, r = replyx, pm = mask; j < sigCnt;
							j++, p++, r += 2, pm++) {
				if (*pm == '1')
					strcat(pline, "0.5 ");
				else {
					pval[0] = *p;
					strcat(pline, pval);
					}
				if (outputs[j]) {
					pval[0] = *r;
					strcat(pline, pval);
					pval[0] = *(r+1);
					strcat(pline, pval);
					}
				}
			strcpy(linex, hex2bin(*p2io));
			for (j = 0, p = linex; j < sigCnt; j++, p++) {
				pval[0] = *p;
				strcat(pline, pval);
				}
			pval[0] = *pd;
			strcat(pline, pval);
			pval[0] = *pe;
			strcat(pline, pval);
			if (i && strcmp(pline, pline2)) {
				tt = i * timestep;
				tt -= timestep * 0.01;
				sig << tt << " " << pline2 << '\n';
				}
			tt = i * timestep;
			sig << tt << " " << pline << '\n';
			strcpy(pline2, pline);
			free(*p2);
			free(*p2o);
#endif
			patternNo++;
			if (! (patternNo % 5000)) {
				logAddFileScreen();
				sprintf(msg, "%d", patternNo);
				logAdd(msg, 0, 0);
				logAddFileOnly();
				}
			}
		packet[0] = 0;
		packetLen = dataCnt = maskCnt = 0;
		if (appendix)	break;
		}
  done:
	if (packetLen) {
		appendix = 1;
		single = 0;
	    goto last;
		}

	portWrite("$", 9, 0);
	portRead(reply, 1);

#if SIGT_AT_END
	pval[1] = ' ';
	pval[2] = 0;
	// Write sigtool plot file
	strcpy(line, fname);
	strcat(line, ".sig");
	sig.open(line);
	sig << "# Signal file" << '\n';
	sig << "TIME ";
	for (i = 0; i < sigCnt; i++) {
		sig << sigNames[i] << " ";
//		if (outputs[i])
			if (debug >= 3)	sig << sigNames[i] << ".io " <<
						sigNames[i] << ".m ";
			if (debug >= 2)	sig << sigNames[i] << ".d ";
			if (debug >= 1)	sig << sigNames[i] << ".e ";
			if (debug >= 4)	sig << sigNames[i] << ".r ";
//			}
		}
#if 0
20-OCT-2007
	for (i = 0; i < sigCnt; i++) {
//		sig << "IO." << sigNames[i] << " ";
		sig << sigNames[i] << ".io ";
		}
#endif
	if (debug >= 2)	sig << "_inout_ _mask_ ";
	if (debug >= 1)	sig << "_diff_ ";
	sig << "_err_ " << '\n';
#endif

	/* sigtool output */
	*pe = 0;
	tpat.close();
	*out << ".............................................." << endl;
	*out << fname << ": " << errors << " errors." << endl;
	*errcnt += errors;
	portSetReadMode();	// '$'
	portSetLogging();
	logAddFileScreen();
	if (! wasOpen) {
		*out << "----------------------------------------------" << endl;
		*out << "Total of " << *errcnt << " errors." << endl;
		out->close();
		}

#if SIGT_AT_END
	if (outCnt != patternCnt) {
		hopa("Invalid number of returned patterns");
		return 1;
		}
	if (timestep &&outCnt == patternCnt ) {
		for (p2 = patterns, p2o = patternsOut,
				pd = patternDiff, pe = patternErr,
				p2m = patternsMask, p2io = patIOMask, i = 0;
			i < patternCnt;
			i++, p2++, p2o++, pd++, pe++, p2m++, p2io++) {
			strcpy(line, hex2bin(*p2));
			strcpy(reply, *p2o);
			strcpy(mask, hex2bin(*p2m));
			strcpy(iob, hex2bin(*p2io));
if (i > 1953)
n = 999;
			pline[0] = 0;
			diffVal = 0;
			for (p = line, r = reply, pm = mask, pio = iob, j = 0;
						j < sigCnt;
						j++, p++, r += 2, pm++, pio++) {
				cc = *p;
				if (*r == '1') {
					cc = (cc == '0') ? '1' : '0';
					}
				pval[0] = cc;
				strcat(pline, pval);
//				if (outputs[j]) {
					pval[0] = *pio;
					if (debug >= 3) strcat(pline, pval);
					pval[0] = *pm;
					if (debug >= 3) strcat(pline, pval);
					pval[0] = *r;
					if (debug >= 2) strcat(pline, pval);
					if (*r == '1')	diffVal |= (1 << j);
					pval[0] = *(r+1);
					if (debug >= 1) strcat(pline, pval);
//					}
				pval[0] = *p;
				if (debug >= 4) strcat(pline, pval);
				}
			// _inout_
			for (n = k = j = 0, pio = iob; j < sigCnt; j++, pio++) {
				if (! outputs[j])	continue;
				n++;
				if (*pio == '1')	k++;
				}
			if (debug >= 2) {
				if (k == n)	strcat(pline, "1 ");	// all
				else if (k)	strcat(pline, "0.5 ");	// some
				else		strcat(pline, "0 ");	// none
				}
			pval[0] = '0';
			// _mask_
			for (pm = mask, j = 0; j < sigCnt; j++, pm++) {
				if (*pm == '1')	pval[0] = '1';
				}
			if (debug >= 2)	strcat(pline, pval);
			// _diff_
			pval[0] = *pd;
			if (debug >= 1)	strcat(pline, pval);
			if (diffVal && *pd == '0' ||
			    ! diffVal && *pd == '1') {
				sprintf(msg, "diffVal=0x%x, *pd=%c\n",
								diffVal, *pd);
				logAddFileScreen();
				logAdd(msg, 0, 0);
				logAddFileOnly();
				}
			// _err_
			pval[0] = *pe;
			strcat(pline, pval);
			if (i && strcmp(pline, pline2)) {
				tt = i * timestep;
				tt -= timestep * 0.01;
				sig << tt << " " << pline2 << '\n';
				}
			tt = i * timestep;
			sig << setprecision(10) << tt << " " << pline << '\n';
			strcpy(pline2, pline);
			free(*p2);
			free(*p2o);
			}
		sig.close();
		}
	free(patterns);
//	free(patternsOut);
	free(patternDiff);
//	free(patternErr);
//	free(patternsMask);
	for (i = 0; i < sigCnt; i++)
		free(sigNames[i]);
#endif

	if (timestep)
		sig.close();
	sprintf(msg, "DONE (%s)", fname);
	logAdd(msg, 0, 0);
	return status;
}


void CTabTest::OnTimer(UINT nIDEvent) 
{
	if (nIDEvent != 1)	return;
// logAdd("TIMER", 0, 0);
	KillTimer(1);
	ofstream out;
	int errcnt = 0;
	digiCancel = 0;
	makeDigitest(digiTPath, &out, 0, &errcnt);
	m_sTErrors.Format("%d", errcnt);
	char msg[256];
	sprintf(msg, "%d errors in %s", errcnt, digiTPath);
	logAdd(msg, 0, 0);
	testReportAdd(msg);
	UpdateData(FALSE);	// Set screen values
}


void CTabTest::OnTDigitest() 
{
	char *types = "Test Program (*.tpat)|*.tpat|All Files (*.*)|*.*||";
	CFileDialog m_ldFile(TRUE, "*.tpat", NULL, 0, types);

	UpdateData(TRUE);	// Get curret values from the screen
	tTTimeout = m_sTTimeout;
	tTNLines = m_sTNLines;
	digiPackLen = atoi(tTNLines.GetBuffer(0));
	if (digiPackLen > MAX_LINES) {
		char msg[256];
		sprintf(msg, "Sending too many lines at a time (%d)",MAX_LINES);
		return;
		}
	// Show the File open dialog and capture the result
	if (m_ldFile.DoModal() != IDOK)
		return;
	// Get the selected filename
	CString cs = m_ldFile.GetPathName();
	char *path;
	path = cs.GetBuffer(0);
#if 0
	ofstream out;
	int errcnt = 0;
	digiPackLen = atoi(tTNLines.GetBuffer(0));
	if (digiPackLen > MAX_LINES) {
		sprintf(msg, "Sending too many lines at a time (%d)", MAX_LINES);
		return;
		}
	digiCancel = 0;
	makeDigitest(path, &out, 0, &errcnt);
	m_sTErrors.Format("%d", errcnt);
	sprintf(msg, "%d errors in %s", errcnt, path);
	logAdd(msg, 0, 0);
	testReportAdd(msg);
	UpdateData(FALSE);	// Set screen values
#endif
	strcpy(digiTPath, path);
	// create a timer with id=1 and delay of 5 milliseconds
	SetTimer(1, 70, NULL);
	OnTimer(1);
}


void CTabTest::OnTDigiCancel() 
{
	logAddFileScreen();
	digiCancel = 1;
	logAddFileScreen();
	char msg[256];
	sprintf(msg, "Digitest canceled");
	logAdd(msg, 0, 0);
	testReportAdd(msg);
}


int testGetSampleNo() 
{
	return sampleNo;
}


#if 0
void CTabTest::OnOK() 
{
 logAdd("OK - OK", 0, 0);
}
#endif


void CTabTest::OnCancel() 
{
}


void CTabTest::OnFirmver() 
{
	char	cmd[CMD_LEN] = "FE";
	if(portWrite(cmd, 0 , 0)) return;
	int nn;
	nn = portRead(cmd, CMD_LEN);
}
